/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mets.dmdsec;

import org.dom4j.Element;

import ch.docuteam.darc.mets.Document;

/**
 * This class, used by the class <a href="../Document.html">Document</a>,
 * represents a generic form of the METS Descriptive Metadata Section. This
 * class gets instantiated when parsing a METS file, a DMDSection is found with
 * neither an OAI_DC nor an EAD element.
 *
 * @author denis
 */
public class DMDSectionGeneric extends DMDSectionAbstract {
	/**
	 * This constructor is used only when a METS-File is being read. Create the
	 * DMDSection out of the given document.
	 */
	protected DMDSectionGeneric(Document document, Element element) {
		super(document, element);
	}

	@Override
	public String toString() {
		return "\n[DMDSection:" + this.id + "]";
	}

}
