/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa;

import java.util.List;

import ch.docuteam.tools.string.StringSet;
import ch.docuteam.tools.string.StringSetElement;

/**
 * This class represents a Submission Agreement status, one of "Pending",
 * "Draft", "Release Candidate", "Suspended", or "Final".
 *
 * @author denis
 *
 */
public class SubmissionAgreementStatus extends StringSetElement {

	static {
		new SubmissionAgreementStatus("Pending");
		new SubmissionAgreementStatus("Draft");
		new SubmissionAgreementStatus("Release Candidate");
		new SubmissionAgreementStatus("Suspended");
		new SubmissionAgreementStatus("Final");
	}

	private SubmissionAgreementStatus(String value) {
		super(value);
	}

	static public SubmissionAgreementStatus get(String value) {
		return (SubmissionAgreementStatus) StringSet.get(SubmissionAgreementStatus.class, value);
	}

	static public List<? extends StringSetElement> getAll() {
		return StringSet.getAll(SubmissionAgreementStatus.class);
	}

}
