/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa.dss;

import java.util.List;

import ch.docuteam.tools.string.StringSet;
import ch.docuteam.tools.string.StringSetElement;

/**
 * This class represents a
 * <a href="./DataSubmissionSession.html">DataSubmissionSession</a> category,
 * one of "Snapshot", "Addition", or "Usage".
 *
 * @author denis
 *
 */
public class DataSubmissionSessionCategory extends StringSetElement {

	static {
		new DataSubmissionSessionCategory("Snapshot");
		new DataSubmissionSessionCategory("Addition");
		new DataSubmissionSessionCategory("Usage");
	}

	private DataSubmissionSessionCategory(String value) {
		super(value);
	}

	static public DataSubmissionSessionCategory get(String value) {
		return (DataSubmissionSessionCategory) StringSet.get(DataSubmissionSessionCategory.class, value);
	}

	static public List<? extends StringSetElement> getAll() {
		return StringSet.getAll(DataSubmissionSessionCategory.class);
	}

}
