/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.util;

import java.io.*;
import java.util.List;

import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.out.Logger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * @author denis
 *
 */
public abstract class CSVExport {

	static private final String Separator = ";";
	static private final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

	static public File export(Document document, String exportFilePath) {
		File exportFile = new File(exportFilePath);

		// Create parent folders if necessary:
		exportFile.getParentFile().mkdirs();

		OutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(exportFile));

			// Header line:
			StringBuilder line = new StringBuilder("Path");
			for (String mdName : MetadataElement.getAll().keySet())
				line.append(Separator).append(mdName);
			line.append("\n");
			out.write(line.toString().getBytes());

			// For all nodes in document:
			for (NodeAbstract node : document.getStructureMap().getRoot().getWithDescendants()) {
				Logger.getLogger().debug(node.getPathString());

				line = new StringBuilder(node.getPathString());

				// For all possible dynamic metadata elements:
				for (String mdName : MetadataElement.getAll().keySet()) {
					try {
						List<String> values = node.getAllDynamicMetadataValuesForName_NoCheck(mdName);

						Logger.getLogger().debug(mdName + ": " + values);

						line.append(Separator);
						if (values != null)
							line.append(GSON.toJson(values));
					} catch (Exception ex) {
						ex.printStackTrace(); // Write exception to the console
												// and continue
					}
				}

				line.append("\n");
				out.write(line.toString().getBytes());
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (IOException ex) {
					ex.printStackTrace();
				}
		}

		return exportFile;
	}

}
