/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.util;

import java.io.*;

import javax.xml.transform.*;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.*;

import ch.docuteam.tools.out.Logger;

/**
 * @author andreas
 *
 */
public abstract class XML2PDF {

	public static File createPDF(String xml, String xslt) throws IOException {
		return createPDF(new File(xml), new File(xslt));
	}

	public static File createPDF(File xml, File xslt) throws IOException {
		File pdf = new File(xml.getParent() + "/" + xml.getName().replace("xml", "pdf"));
		return createPDF(xml, xslt, pdf);
	}

	public static File createPDF(String xml, String xslt, String pdf) throws IOException {
		return createPDF(new File(xml), new File(xslt), new File(pdf));
	}

	public static File createPDF(File xml, File xslt, File pdf) throws IOException {
		Logger.info("Initializing transformation...");
		pdf.getParentFile().mkdirs();
		OutputStream out = new java.io.BufferedOutputStream(new java.io.FileOutputStream(pdf));

		Logger.info("Input: XML (" + xml + ")");
		Logger.info("Stylesheet: " + xslt);
		Logger.info("Output: PDF (" + pdf + ")");
		Logger.info("Transforming...");

		FopFactory fopFactory = FopFactory.newInstance();

		try {
			// Construct fop with desired output format
			Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, out);

			// Setup XSLT
			TransformerFactory factory = new net.sf.saxon.TransformerFactoryImpl();
			Transformer transformer = factory.newTransformer(new StreamSource(xslt));

			// Set the value of a <param> in the stylesheet
			transformer.setParameter("versionParam", "2.0");

			// Setup input for XSLT transformation
			Source src = new StreamSource(xml);

			// Resulting SAX events (the generated FO) must be piped through to
			// FOP
			Result res = new SAXResult(fop.getDefaultHandler());

			// Start XSLT transformation and FOP processing
			transformer.transform(src, res);
		} catch (FOPException e) {
			e.printStackTrace();
			return null;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			return null;
		} catch (TransformerException e) {
			e.printStackTrace();
			return null;
		} finally {
			out.close();
		}

		return pdf;
	}

}
