package ch.docuteam.packer.gui.launcher.actions;

import static ch.docuteam.packer.gui.PackerConstants.OPEN_IN_WORKSPACE_PNG;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import ch.docuteam.darc.mets.Document.Mode;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.translations.I18N;

public class OpenSIPInWorkspaceAction extends AbstractDocuAction {

	public OpenSIPInWorkspaceAction(LauncherView owner) {
		super(I18N.translate("ActionOpenInWorkspace"),
				new ImageIcon(OPEN_IN_WORKSPACE_PNG), owner);
		putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipOpenInWorkspace"));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		owner.openSelectedSIPInWorkspace(Mode.ReadWrite);

	}

}
