package ch.docuteam.packer.gui.sipView.actions;

import static ch.docuteam.packer.gui.PackerConstants.MIGRATE_PNG;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.ImageIcon;

import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.translations.I18N;

public class AppendMigratedFileAction extends AbstractSIPViewAction {

	public AppendMigratedFileAction(SIPView sipView) {
		super(I18N.translate("ButtonAppendMigratedFile"), new ImageIcon(MIGRATE_PNG), sipView);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		int selectedRow = sipView.getTreeTable().getSelectedRow();
		NodeAbstract selectedNode = (NodeAbstract) sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent();

		AppendMigratedFileDialog dialog = new AppendMigratedFileDialog(this.sipView, selectedNode);
		if (!dialog.goButtonWasClicked)
			return;

		File newFile = new File(dialog.derivedFileTextField.getText());
		if (!newFile.exists())
			return;
		
		if (dialog.keepOriginalCheckBox.isSelected()) {
			try {
				((NodeFile)selectedNode).migrateToFileKeepOriginal(newFile.getAbsolutePath(), "docuteam packer");
			} catch (FileOperationNotAllowedException | FileUtilExceptionListException | IOException | FileAlreadyExistsException e1) {
				e1.printStackTrace();
			}
		} else {
			try {
				((NodeFile)selectedNode).migrateToFile(newFile.getAbsolutePath(), "docuteam packer");
			} catch (FileOperationNotAllowedException | FileUtilExceptionListException | IOException | FileAlreadyExistsException e1) {
				e1.printStackTrace();
			}
		}

		// Refresh the selected node:
		sipView.getTreeTableModel().refreshTreeStructure(sipView.getTreeTable().getPathForRow(selectedRow));
		sipView.enableOrDisableActions();
	}

	@Override
	public void enableOrDisable() {
		boolean isEnabled = false;

		if (sipView.getTreeTable().getSelectedRowCount() == 1) {
			int selectedRow = sipView.getTreeTable().getSelectedRow();
			NodeAbstract node = (NodeAbstract) sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent();
				
			// enabled is a consequence of several of the conditions being true
			// for all the selected nodes
			isEnabled = 
					node.isFile()
					&& node.canRead()
					&& node.canWrite()
					&& ((NodeFile)node).getMigrationDerivedNode() == null
					&& node.getSubmitStatus().isEditingAllowed();
		}
		
		setEnabled(isEnabled);
	}

}
