package ch.docuteam.packer.gui.sipView.actions;

import static ch.docuteam.packer.gui.PackerConstants.CHECKSUM_PNG;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.gui.ScrollableMessageDialog;
import ch.docuteam.tools.translations.I18N;

public class CheckFixityAction extends AbstractSIPViewAction {

	public CheckFixityAction(SIPView sipView) {
		super(I18N.translate("ButtonCheckFixity"), new ImageIcon(CHECKSUM_PNG), sipView);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (sipView.getDocument().checkFixity()) {
			JOptionPane.showMessageDialog(sipView, I18N.translate("MessageFixityCheckSuccessful"),
					I18N.translate("HeaderFixityCheck"), JOptionPane.INFORMATION_MESSAGE);
		} else {
			new ScrollableMessageDialog(sipView, I18N.translate("HeaderFixityCheck"),
					I18N.translate("MessageFixityCheckFailed") + "\n" + ExceptionCollector.getAll());
		}
	}

	@Override
	public void enableOrDisable() {
		//	always enabled
		setEnabled(true);
	}

}
