/**
 *	Copyright (C) 2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ch.docuteam.packer.gui.sipView.actions;

import static ch.docuteam.packer.gui.PackerConstants.DELETE_PNG;

import java.awt.event.ActionEvent;
import java.io.IOException;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.NodeFileDeletionNotAllowedException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeAbstract.SubmitStatus;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.translations.I18N;

/**
 * @author iliya
 *
 */
public class DeleteFileContentAction extends AbstractSIPViewAction {

	public DeleteFileContentAction(SIPView sipView) {
		super(I18N.translate("DeleteFileContent"), new ImageIcon(DELETE_PNG), sipView);
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipDeleteFileContent"));
	}

	@Override
	public void actionPerformed(ActionEvent actionEvent) {

		int selectedRowCount = sipView.getTreeTable().getSelectedRowCount();
		if (selectedRowCount == 0) {
			return;
		} else {
			int[] selectedRows = sipView.getTreeTable().getSelectedRows();
			if (JOptionPane.showConfirmDialog(sipView, I18N.translate("QuestionDeleteFileContent"),
					I18N.translate("TitleDeleteFileContent"), JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
				// TODO Exceptions should be handled properly
				try {
					for (int selectedRow : selectedRows) {
						((NodeFile) sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent())
								.deleteFileContent();
						// sipView.getTreeTable().getPathForRow(selectedRow)
						sipView.getTreeTableModel().refreshTreeStructure(sipView.getTreeTable().getPathForRow(selectedRow));
						sipView.getTreeTableModel().refreshNode(sipView.getTreeTable().getPathForRow(selectedRow));
					}
				} catch (IOException | FileOperationNotAllowedException | FileUtilExceptionListException e) {
					e.printStackTrace();
				} catch (NodeFileDeletionNotAllowedException e) {
					e.printStackTrace();
				}
			} else {
				return;
			}
		}
	}
	@Override
	public void enableOrDisable() {
		int selectedRowCount = sipView.getTreeTable().getSelectedRowCount();
		boolean isEnabled = selectedRowCount > 0;
		int[] selectedRows = sipView.getTreeTable().getSelectedRows();

		for (int selected : selectedRows) {
			NodeAbstract node = (NodeAbstract) sipView.getTreeTable().getPathForRow(selected).getLastPathComponent();
			// enabled is a consequence of several of the conditions being true
			// for all the selected nodes
			boolean enabledForCurrentNode = node.isFile() && node.canWrite()
					&& node.getSubmitStatus().equals(SubmitStatus.Submitted);
			isEnabled &= enabledForCurrentNode;
		}

		setEnabled(isEnabled);
	}

}
