package ch.docuteam.packer.gui.sipView.actions;

import static ch.docuteam.packer.gui.PackerConstants.DELETE_PNG;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.translations.I18N;

public class DeleteItemAction extends AbstractSIPViewAction {

	public DeleteItemAction(SIPView sipView) {
		super(I18N.translate("ButtonDeleteItem"), new ImageIcon(DELETE_PNG), sipView);
		putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0));
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipDeleteItem"));
	}

	@Override
	public void actionPerformed(ActionEvent e) {

		// If the shift-key is held while clicking the delete-button: DON'T ask.

		if ((e.getModifiers() & ActionEvent.SHIFT_MASK) == 0) {
			// The shift-key was pressed:

			int selectedRowCount = sipView.getTreeTable().getSelectedRowCount();
			if (selectedRowCount == 0)
				return;
			else if (selectedRowCount == 1) {
				// Single selection:

				if (sipView.getSelectedNode().isFolder() && (sipView.getSelectedNode().getChildCount() != 0)) {
					if (JOptionPane.showConfirmDialog(sipView, I18N.translate("QuestionDeleteWithAllSubElements"),
							I18N.translate("TitleDeleteFolder"), JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION)
						return;
				} else {
					if (JOptionPane.showConfirmDialog(sipView, I18N.translate("QuestionDeleteItem"),
							I18N.translate("TitleDeleteItem"), JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION)
						return;
				}
			} else {
				// Multiple selection:

				if (JOptionPane.showConfirmDialog(sipView,
						I18N.translate("QuestionDeleteMultipleItems", selectedRowCount),
						I18N.translate("TitleDeleteMultipleItems"),
						JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION)
					return;
			}
		}

		sipView.deleteItemDontAskButtonClicked();

	}

	@Override
	public void enableOrDisable() {
		boolean canDelete = sipView.getDocument().isReadWrite();
		
	}

}
