package ch.docuteam.packer.gui.sipView.actions;

import static ch.docuteam.packer.gui.PackerConstants.SAVE_PNG;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.translations.I18N;

/**
 * Currently this class is not used but will be used by SipView
 * @author iliya
 *
 */
public class SaveAction extends AbstractSIPViewAction {

	public SaveAction(SIPView sipView) {
		super(I18N.translate("ButtonSave"), new ImageIcon(SAVE_PNG), sipView);
		putValue(Action.ACCELERATOR_KEY,
				KeyStroke.getKeyStroke(KeyEvent.VK_S, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipSave"));
		setEnabled(true);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		SaveUtility su = new SaveUtility();
		//	If the shift-key is held while clicking the save-button: ask for a file name to save a copy to:
		if ((e.getModifiers() & ActionEvent.SHIFT_MASK) != 0)
		{
			su.saveAsButtonClicked();
		}
		else
		{
			su.saveCopyAs(null, false);
		}
	
	}

	@Override
	public void enableOrDisable() {
		// TODO this is still done in sipview
		
	}

}
