package ch.docuteam.packer.gui.sipView.cellRenderer;

import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class RelativeSizeBarTableCellRenderer extends DefaultTableCellRenderer {

	// 100 vertical bars:
	private static final String BARS = "||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||";
	// Magic Number: approximate width of the "|" character in pixels!
	private static final int BAR_CHAR_WIDTH = 5;

	private TableColumn column;

	public RelativeSizeBarTableCellRenderer(TableColumn column) {
		this.column = column;
	}

	@Override
	public void setValue(Object object) {
		if (object == null)
			return;

		int columnWidth = column.getWidth();
		float relativeFileSize = new Integer(object.toString()).floatValue() / 100;

		int nrOfBars100 = columnWidth / BAR_CHAR_WIDTH;
		int nrOfBars = (int) (relativeFileSize * nrOfBars100);
		String bars = BARS.substring(0, Math.min(BARS.length(), nrOfBars));

		setToolTipText("" + relativeFileSize);
		super.setValue(bars);
	}

}
