package ch.docuteam.packer.gui.sipView.tableModel;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.tools.translations.I18N;

public class BadFilesTableModel extends AbstractTableModel {

	List<NodeFile> badFiles = new ArrayList<NodeFile>();

	public void clearList() {
		badFiles.clear();
		fireTableDataChanged();
	}

	public void setList(List<NodeFile> badFiles) {
		this.badFiles = badFiles;
		fireTableDataChanged();
	}

	public List<NodeFile> getList() {
		return badFiles;
	}

	public NodeFile get(int i) {
		return badFiles.get(i);
	}

	@Override
	public int getRowCount() {
		return badFiles.size();
	}

	@Override
	public int getColumnCount() {
		return 2;
	}

	@Override
	public String getColumnName(int columnIndex) {
		switch (columnIndex) {
		case 0:
			return I18N.translate("HeaderNodePath");
		case 1:
			return I18N.translate("HeaderNodeIsAllowedBySA");
		}

		return null;
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		switch (columnIndex) {
		case 0:
			return String.class;
		case 1:
			return Boolean.class;
		}

		return null;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		NodeFile nodeFile = badFiles.get(rowIndex);
		if (nodeFile == null) {
			return null;
		}

		switch (columnIndex) {
		case 0:
			return nodeFile.getPathString();
		case 1:
			return !nodeFile.isAllowedBySA();
		}

		return null;
	}

}
