package ch.docuteam.packer.gui.sipView.tableModel;

import javax.swing.table.AbstractTableModel;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.tools.translations.I18N;

public class EventListTableModel extends AbstractTableModel {

	private NodeAbstract fileStructureNode;

	public void setFileStructureNode(NodeAbstract fileStructureNode) {
		this.fileStructureNode = fileStructureNode;
		fireTableDataChanged();
	}

	public NodeAbstract getFileStructureNode() {
		return fileStructureNode;
	}

	@Override
	public int getRowCount() {
		if (fileStructureNode == null)
			return 0;

		return fileStructureNode.getMyEvents().size();
	}

	@Override
	public int getColumnCount() {
		return 3;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getColumnName(int column) {
		switch (column) {
		case 0:
			return I18N.translate("HeaderTimestamp");
		case 1:
			return I18N.translate("HeaderType");
		case 2:
			return I18N.translate("HeaderEventOutcome");
		}

		return null;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (fileStructureNode == null)
			return 0;

		Event event = fileStructureNode.getMyEvent(rowIndex);

		switch (columnIndex) {
		case 0:
			return event.getDateTime();
		case 1:
			return event.getType();
		case 2:
			return event.getOutcome();
		}

		return null;
	}

}
