/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.file;

import uk.gov.nationalarchives.droid.core.interfaces.*;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;


/**
 * @author denis
 *
 * An implementation of the uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult interface that offers a
 * constructor which takes an additional FileFormat parameter.
 *
 * This is needed because when getting file identifications of container type in the class file.MetadataProviderDROID, the name, mime type,
 * and version of the file identification are not supplied.
 * With this class, the additional FileFormat object supplies the missing values.
 */
public class MetadataProviderDROID_IdentificationResult implements IdentificationResult
{

	private String puid;
	private String name;
	private String mimeType;
	private String version;
	private String extId;
	private IdentificationMethod method;

	public MetadataProviderDROID_IdentificationResult()
	{
		super();
	}

	public MetadataProviderDROID_IdentificationResult(IdentificationResult identificationResult)
	{
		this.puid = identificationResult.getPuid();
		this.extId = identificationResult.getExtId();
		this.mimeType = identificationResult.getMimeType();
		this.name = identificationResult.getName();
		this.version = identificationResult.getVersion();
		this.method = identificationResult.getMethod();
	}

	public MetadataProviderDROID_IdentificationResult(IdentificationResult identificationResult, FileFormat fileFormat)
	{
		this(identificationResult);

		this.mimeType = fileFormat.getMimeType();
		this.name = fileFormat.getName();
		this.version = fileFormat.getVersion();
	}


	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getPuid()
	 */
	@Override
	public String getPuid()
	{
		return this.puid;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getExtId()
	 */
	@Override
	public String getExtId()
	{
		return this.extId;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getName()
	 */
	@Override
	public String getName()
	{
		return this.name;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getMimeType()
	 */
	@Override
	public String getMimeType()
	{
		return this.mimeType;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getVersion()
	 */
	@Override
	public String getVersion()
	{
		return this.version;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getMethod()
	 */
	@Override
	public IdentificationMethod getMethod()
	{
		return this.method;
	}


	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getMetaData()
	 *
	 * A dummy method which returns null because this is not needed here.
	 */
	@Override
	public RequestMetaData getMetaData()
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult#getIdentifier()
	 *
	 * A dummy method which returns null because this is not needed here.
	 */
	@Override
	public RequestIdentifier getIdentifier()
	{
		return null;
	}


}
