/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.os;

import java.io.File;


//TODO Needs rework
public abstract class OperatingSystem
{

	private static String OSName;
	private static String OSVersion;
	private static String UserName;
	private static String UserLanguage;
	private static String UserHome;
	private static String JavaTempDir;

	private static Boolean IsWindows = false;
	private static Boolean IsMacOSX = false;
	private static Boolean IsLinux = false;


	public static String osName()
	{
		initializeIfNecessary();

		return OSName;
	}

	public static String osVersion()
	{
		initializeIfNecessary();

		return OSVersion;
	}

	public static String userName()
	{
		initializeIfNecessary();

		return UserName;
	}

	public static String userLanguage()
	{
		initializeIfNecessary();

		return UserLanguage;
	}


	/**
	 *
	 * @return the user home dir INCLUDING trailing file separator.
	 */
	public static String userHome()
	{
		initializeIfNecessary();

		return UserHome;
	}

	/**
	 *
	 * @return the java temp dir INCLUDING trailing file separator.
	 */
	public static String javaTempDir()
	{
		initializeIfNecessary();

		return JavaTempDir;
	}


	public static boolean isWindows()
	{
		initializeIfNecessary();

		return IsWindows;
	}

	public static boolean isMacOSX()
	{
		initializeIfNecessary();

		return IsMacOSX;
	}

	public static boolean isLinux()
	{
		initializeIfNecessary();

		return IsLinux;
	}


	public static void beep(Integer times)
	{
		beep(times, 500);
	}

	public static void beep(Integer times, Integer mSexGap)
	{
		try
		{
			for (int i = 0; i < times; i++)
			{
				beep();
				Thread.sleep(mSexGap);
			}
		}
		catch (InterruptedException ex){}
	}

	public static void beep()
	{
		java.awt.Toolkit.getDefaultToolkit().beep();
	}


	private static void initializeIfNecessary()
	{
		if (OSName == null)		initialize();
	}


	private static void initialize()
	{
		OSName = System.getProperty("os.name");
		OSVersion = System.getProperty("os.version");
		UserName = System.getProperty("user.name");
		UserLanguage = System.getProperty("user.language");
		UserHome = System.getProperty("user.home");
		if (!UserHome.endsWith(File.separator))			UserHome += File.separator;
		JavaTempDir = System.getProperty("java.io.tmpdir");
		if (!JavaTempDir.endsWith(File.separator))		JavaTempDir += File.separator;

		String osNameLower = OSName.toLowerCase();
		if (osNameLower.contains("windows"))		IsWindows = true;
		else if (osNameLower.contains("os x"))		IsMacOSX = true;
		else if (osNameLower.contains("linux"))		IsLinux = true;
	}


}
