/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.string;

import java.util.List;
import java.util.Vector;

//TODO this class should be renamed
public class Pattern {

	//TODO 
	private static final String RegexMetaCharacters = "[\\^$.|?*+()";
	private static final Character DefaultWildcardMultiple = '*';
	private static final Character DefaultWildcardSingle = '?';

	private static final String RegexWildcardMultiple = ".*";
	private static final String RegexWildcardSingle = ".";

	private List<java.util.regex.Pattern> regexPatterns = new Vector<java.util.regex.Pattern>();

	public Pattern(String... patterns) {
		this(DefaultWildcardMultiple, DefaultWildcardSingle, patterns);
	}

	public Pattern(char wildcardMultiple, char wildcardSingle, String... patterns) {
		for (String pattern : patterns) {
			// Quote all regex metaCharacters:
			StringBuilder regexPattern = new StringBuilder();
			for (int i = 0; i < pattern.length(); i++) {
				Character c = pattern.charAt(i);
				if (c == wildcardMultiple)
					regexPattern.append(RegexWildcardMultiple);
				else if (c == wildcardSingle)
					regexPattern.append(RegexWildcardSingle);
				else if (RegexMetaCharacters.contains(c.toString()))
					regexPattern.append("\\").append(c); // Quote
				else
					regexPattern.append(c); // Copy
			}

			// Create a compiled regexPattern:
			this.regexPatterns.add(java.util.regex.Pattern.compile(regexPattern.toString()));
		}
	}

	/**
	 * Return true if and only if the supplied string matches any of the
	 * patterns.
	 * 
	 * @param match
	 * @return
	 */
	public boolean match(String match) {
		for (java.util.regex.Pattern p : this.regexPatterns)
			if (p.matcher(match).matches())
				return true;

		return false;
	}

}
