/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.util;

import bsh.EvalError;
import bsh.Interpreter;


/**
 * This class is a wrapper around bsh.Interpreter which can interpret java expressions.
 * <p>
 * Sooner or later, this class should be moved to docutools.
 *
 * @author denis
 *
 */
public abstract class JavaInterpreter
{

	private static final Interpreter		BeanShellInterpreter = new Interpreter();


	/**
	 * Return the result of evaluating the passed string.
	 */
	public static Object execute(String s) throws EvalError
	{
		return BeanShellInterpreter.eval(s);
	}


	/**
	 * Set the variable "object" to the parameter o, then return the result of evaluating the passed string, which can reference the object.
	 * @param o
	 * @param s
	 * @return
	 * @throws EvalError
	 * @deprecated  As of release 2.14.1, replaced by {@link #execute(String s, Object... o)}
	 */
	@Deprecated
	public static Object execute(Object o, String s) throws EvalError
	{
		BeanShellInterpreter.set("object", o);
		return execute(s);
	}

	/**
	 * Evaluates an expression referencing an arbitrary number of objects varargs.
	 * Example:
	 * Calendar calendar = GregorianCalendar.getInstance(2010, 8, 1);								// calendar = object1
	 * DateFormat df = SimpleDateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM);  // df = object2
	 * String formattedDate = execute("object2.format(object1.getTime())", calendar, df);
	 * formattedDate = "01.09.2010 00:00:00"
	 * @param expression
	 * @param varargs
	 * @return result of evaluation
	 * @throws EvalError
	 */
	public static Object execute(String expression, Object... varargs) throws EvalError
	{
		for (int i = 0; i < varargs.length; i++)
		{
			BeanShellInterpreter.set("object" + (i + 1), varargs[i]);
		}
		return execute(expression);
	}

}
