/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.aiff.AnnotationChunk;
import edu.harvard.hul.ois.jhove.module.aiff.ApplicationChunk;
import edu.harvard.hul.ois.jhove.module.aiff.AudioRecChunk;
import edu.harvard.hul.ois.jhove.module.aiff.AuthorChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CommentsChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CommonChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CopyrightChunk;
import edu.harvard.hul.ois.jhove.module.aiff.ExtDouble;
import edu.harvard.hul.ois.jhove.module.aiff.FormatVersionChunk;
import edu.harvard.hul.ois.jhove.module.aiff.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.aiff.MarkerChunk;
import edu.harvard.hul.ois.jhove.module.aiff.MidiChunk;
import edu.harvard.hul.ois.jhove.module.aiff.NameChunk;
import edu.harvard.hul.ois.jhove.module.aiff.SaxelChunk;
import edu.harvard.hul.ois.jhove.module.aiff.SoundDataChunk;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AiffModule
extends ModuleBase {
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected List _propList;
    protected AESAudioMetadata _aesMetadata;
    protected List _annotationList;
    protected List _midiList;
    protected List _saxelList;
    protected long bytesRemaining;
    protected boolean soundChunkSeen;
    protected boolean formatVersionChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean commonChunkSeen;
    protected boolean commentsChunkSeen;
    protected boolean nameChunkSeen;
    protected boolean authorChunkSeen;
    protected boolean copyrightChunkSeen;
    protected boolean markerChunkSeen;
    protected boolean audioRecChunkSeen;
    protected boolean firstSampleOffsetMarked;
    protected int fileType;
    private static final boolean BIGENDIAN = true;
    public static final int AIFFTYPE = 1;
    public static final int AIFCTYPE = 2;
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private static final String NAME = "AIFF-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2006, 9, 5};
    private static final String[] FORMAT = new String[]{"AIFF", "Audio Interchange File Format"};
    private static final String COVERAGE = "AIFF 1.3, AIFF-C";
    private static final String[] MIMETYPE = new String[]{"audio/x-aiff", "application/aiff"};
    private static final String WELLFORMED = "Magic number: \"FORM\" at byte offset 0; \"AIFF\"(for AIFF) or \"AIFC\" (for AIFF-C) at offset 8; one Form chunk containing one Common chunk and at most one Sound Data chunk (if numSampleFrames > 0); at most one instance of each of the following optional chunks: Marker, Instrument, Audio Recording, Comments, Name, Author, Copyright; all chunks required by a given profile exist in the file; all chunk structures are well-formed: a four ASCII character ID, followed by a 32 signed integer size, followed by a size byte data block (if size is odd, then the data block includes a final padding byte of value 0x00); and no data exist before the first byte of the chunk or after the last byte of the last chunk";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "Properties capturing the technical attributes of the audio from all chunks";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public AiffModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("Audio Interchange File Format: \"AIFF\", A Standard for Sampled Sound Files, Version 1.3", DocumentType.REPORT);
        agent = new Agent("Apple Computer, Inc.", AgentType.COMMERCIAL);
        agent.setAddress("1 Infinite Loop, Cupertino, CA 95014");
        agent.setTelephone("(408) 996-1010");
        agent.setWeb("http://www.apple.com/");
        document.setAuthor(agent);
        document.setDate("1989-01-04");
        document.setIdentifier(new Identifier("http://developer.apple.com/documentation/QuickTime/INMAC/SOUND/imsoundmgr.30.htm#pgfId=3190", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("Audio Interchange File Format AIFF-C: A revision to include compressed audio data", DocumentType.REPORT);
        document.setAuthor(agent);
        document.setDate("1991-08-26");
        document.setNote("*** DRAFT ***");
        this._specification.add(document);
        ExternalSignature externalSignature = new ExternalSignature("AIFF", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(externalSignature);
        externalSignature = new ExternalSignature("AIFC", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(externalSignature);
        externalSignature = new ExternalSignature(".aif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(externalSignature);
        externalSignature = new ExternalSignature(".aifc", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For AIFF-C profile");
        this._signature.add(externalSignature);
        externalSignature = new InternalSignature("FORM", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(externalSignature);
        externalSignature = new InternalSignature("AIFF", SignatureType.MAGIC, SignatureUseType.OPTIONAL, 8, "For AIFF profile");
        this._signature.add(externalSignature);
        externalSignature = new InternalSignature("AIFC", SignatureType.MAGIC, SignatureUseType.OPTIONAL, 0, "For AIFF-C profile");
        this._signature.add(externalSignature);
        this._bigEndian = true;
    }

    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        int n2;
        this.initParse();
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        this._aesMetadata.setPrimaryIdentifier(repInfo.getUri());
        if (repInfo.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, this._ckSummer);
            this._dstream = AiffModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = AiffModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        try {
            for (n2 = 0; n2 < 4; ++n2) {
                int n3 = AiffModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (n3 == sigByte[n2]) continue;
                repInfo.setMessage((Message)new ErrorMessage("Document does not start with AIFF FORM Chunk", 0L));
                repInfo.setWellFormed(0);
                return 0;
            }
            repInfo.setSigMatch(this._name);
            this.bytesRemaining = AiffModule.readUnsignedInt((DataInputStream)this._dstream, (boolean)true, (ModuleBase)this);
            if (!this.readFileType(repInfo)) {
                return 0;
            }
            while (this.bytesRemaining > 0L && this.readChunk(repInfo)) {
            }
        }
        catch (EOFException eOFException) {
            repInfo.setWellFormed(0);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected EOF", this._nByte));
            return 0;
        }
        if (!this.commonChunkSeen) {
            repInfo.setWellFormed(0);
            repInfo.setMessage((Message)new ErrorMessage("Document does not contain a Common Chunk"));
        }
        if (this.fileType == 2 && !this.formatVersionChunkSeen) {
            repInfo.setWellFormed(0);
            repInfo.setMessage((Message)new ErrorMessage("AIFF-C document must contain a Format Version Chunk"));
        }
        if (repInfo.getWellFormed() != 1) {
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                while ((n2 = this.skipBytes(this._dstream, 2048, this)) != 0) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            repInfo.setSize(this._cstream.getNBytes());
            repInfo.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String string = this._ckSummer.getMD5();
            if (string != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
            }
            if ((string = this._ckSummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
            }
        }
        if (this.fileType == 1) {
            repInfo.setProfile("AIFF");
        } else if (this.fileType == 2) {
            repInfo.setProfile("AIFF-C");
        }
        this._aesMetadata.setByteOrder(this._bigEndian ? 0 : 1);
        if (!this._annotationList.isEmpty()) {
            this._propList.add(new Property("Annotations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._annotationList));
        }
        if (!this._midiList.isEmpty()) {
            this._propList.add(new Property("MIDIData", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._midiList));
        }
        if (!this._saxelList.isEmpty()) {
            this._propList.add(new Property("Saxels", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._saxelList));
        }
        repInfo.setProperty(this._metadata);
        return 0;
    }

    public void setEndian(boolean bl) {
        this._bigEndian = bl;
    }

    public void addAiffProperty(Property property) {
        this._propList.add(property);
    }

    public void addAnnotation(Property property) {
        this._annotationList.add(property);
    }

    public void addSaxel(Property property) {
        this._saxelList.add(property);
    }

    public void addMidi(Property property) {
        this._midiList.add(property);
    }

    protected void initParse() {
        super.initParse();
        this._propList = new LinkedList();
        this._metadata = new Property("AIFFMetadata", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._propList);
        this.firstSampleOffsetMarked = false;
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("AIFF");
        this._aesMetadata.setSpecificationVersion("1.3 (1989-01-04)");
        this._aesMetadata.setAudioDataEncoding("PCM");
        this._aesMetadata.clearBitrateReduction();
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, (Object)this._aesMetadata));
        this._annotationList = new LinkedList();
        this._midiList = new LinkedList();
        this._saxelList = new LinkedList();
        this.soundChunkSeen = false;
        this.commonChunkSeen = false;
        this.markerChunkSeen = false;
        this.formatVersionChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.commentsChunkSeen = false;
        this.nameChunkSeen = false;
        this.authorChunkSeen = false;
        this.audioRecChunkSeen = false;
        this.copyrightChunkSeen = false;
    }

    public long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        return AiffModule.readUnsignedInt((DataInputStream)dataInputStream, (boolean)true, (ModuleBase)this);
    }

    public int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        return AiffModule.readUnsignedShort((DataInputStream)dataInputStream, (boolean)true, (ModuleBase)this);
    }

    public int readSignedShort(DataInputStream dataInputStream) throws IOException {
        return AiffModule.readSignedShort((DataInputStream)dataInputStream, (boolean)true, (ModuleBase)this);
    }

    public double read80BitDouble(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[10];
        AiffModule.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)this);
        ExtDouble extDouble = new ExtDouble(byArray);
        return extDouble.toDouble();
    }

    public String read4Chars(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int n = AiffModule.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this);
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String readPascalString(DataInputStream dataInputStream) throws IOException {
        int n = AiffModule.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this);
        byte[] byArray = new byte[n];
        AiffModule.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)this);
        if ((n & 1) == 0) {
            this.skipBytes(this._dstream, 1, this);
        }
        return new String(byArray, "MacRoman");
    }

    public Date timestampToDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1904, 0, 1, 0, 0, 0);
        int n = (int)(l / 3600L);
        int n2 = (int)(l - (long)n * 3600L);
        calendar.add(11, n);
        calendar.add(13, n2);
        return calendar.getTime();
    }

    public int getFileType() {
        return this.fileType;
    }

    public void markFirstSampleOffset(long l) {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte + l);
        }
    }

    protected boolean readFileType(RepInfo repInfo) throws IOException {
        String string = this.read4Chars(this._dstream);
        this.bytesRemaining -= 4L;
        if ("AIFF".equals(string)) {
            this.fileType = 1;
            return true;
        }
        if ("AIFC".equals(string)) {
            this.fileType = 2;
            this._aesMetadata.setFormat("AIFF-C");
            this._aesMetadata.setSpecificationVersion("Draft 1991-08-26");
            return true;
        }
        repInfo.setMessage((Message)new ErrorMessage("File type in Form Chunk is not AIFF or AIFC", this._nByte));
        repInfo.setWellFormed(0);
        return false;
    }

    protected boolean readChunk(RepInfo repInfo) throws IOException {
        Chunk chunk = null;
        ChunkHeader chunkHeader = new ChunkHeader(this, repInfo);
        if (!chunkHeader.readHeader(this._dstream)) {
            return false;
        }
        int n = (int)chunkHeader.getSize();
        this.bytesRemaining -= (long)(n + 8);
        String string = chunkHeader.getID();
        if ("FVER".equals(string)) {
            if (this.formatVersionChunkSeen) {
                this.dupChunkError(repInfo, "Format Version");
            }
            chunk = new FormatVersionChunk(this, chunkHeader, this._dstream);
            this.formatVersionChunkSeen = true;
        } else if ("APPL".equals(string)) {
            chunk = new ApplicationChunk(this, chunkHeader, this._dstream);
        } else if ("COMM".equals(string)) {
            if (this.commonChunkSeen) {
                this.dupChunkError(repInfo, "Common");
            }
            chunk = new CommonChunk(this, chunkHeader, this._dstream);
            this.commonChunkSeen = true;
        } else if ("SSND".equals(string)) {
            if (this.soundChunkSeen) {
                this.dupChunkError(repInfo, "Sound");
            } else {
                chunk = new SoundDataChunk(this, chunkHeader, this._dstream);
                this.soundChunkSeen = true;
            }
        } else if ("COMT".equals(string)) {
            if (this.commentsChunkSeen) {
                this.dupChunkError(repInfo, "Comments");
            }
            chunk = new CommentsChunk(this, chunkHeader, this._dstream);
            this.commentsChunkSeen = true;
        } else if ("INST".equals(string)) {
            if (this.instrumentChunkSeen) {
                this.dupChunkError(repInfo, "Instrument");
            }
            chunk = new InstrumentChunk(this, chunkHeader, this._dstream);
            this.instrumentChunkSeen = true;
        } else if ("MARK".equals(string)) {
            if (this.markerChunkSeen) {
                this.dupChunkError(repInfo, "Marker");
            } else {
                chunk = new MarkerChunk(this, chunkHeader, this._dstream);
                this.markerChunkSeen = true;
            }
        } else if ("MIDI".equals(string)) {
            chunk = new MidiChunk(this, chunkHeader, this._dstream);
        } else if ("NAME".equals(string)) {
            if (this.nameChunkSeen) {
                this.dupChunkError(repInfo, "Name");
            } else {
                chunk = new NameChunk(this, chunkHeader, this._dstream);
                this.nameChunkSeen = true;
            }
        } else if ("AUTH".equals(string)) {
            if (this.authorChunkSeen) {
                this.dupChunkError(repInfo, "Author");
            } else {
                chunk = new AuthorChunk(this, chunkHeader, this._dstream);
                this.authorChunkSeen = true;
            }
        } else if ("(c) ".equals(string)) {
            if (this.copyrightChunkSeen) {
                this.dupChunkError(repInfo, "Copyright");
            } else {
                chunk = new CopyrightChunk(this, chunkHeader, this._dstream);
                this.copyrightChunkSeen = true;
            }
        } else if ("AESD".equals(string)) {
            if (this.audioRecChunkSeen) {
                this.dupChunkError(repInfo, "Audio Recording");
            } else {
                chunk = new AudioRecChunk(this, chunkHeader, this._dstream);
                this.audioRecChunkSeen = true;
            }
        } else if ("SAXL".equals(string)) {
            chunk = new SaxelChunk(this, chunkHeader, this._dstream);
        } else if ("ANNO".equals(string)) {
            chunk = new AnnotationChunk(this, chunkHeader, this._dstream);
        } else {
            repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string + "' ignored", this._nByte));
        }
        if (chunk != null) {
            if (!chunk.readChunk(repInfo)) {
                return false;
            }
        } else {
            this.skipBytes(this._dstream, n, this);
        }
        if ((n & 1) != 0) {
            this.skipBytes(this._dstream, 1, this);
            --this.bytesRemaining;
        }
        return true;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo repInfo, String string) {
        repInfo.setMessage((Message)new ErrorMessage("Multiple " + string + " Chunks not permitted", this._nByte));
        repInfo.setValid(false);
    }
}

