/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PaletteBox
extends JP2Box {
    public PaletteBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        int n;
        if (!(this._parentBox instanceof JP2HeaderBox)) {
            this._repInfo.setMessage((Message)new ErrorMessage("Image Header Box in illegal context", this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        int n2 = (int)this._boxHeader.getDataLength();
        long l = this._module.getFilePos();
        int n3 = this._module.readUnsignedShort(this._dstrm);
        if (n3 < 1 || n3 > 1024) {
            this._repInfo.setMessage((Message)new ErrorMessage("Palette must have 1 to 1024 entries", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        Property[] propertyArray = new Property[4];
        propertyArray[0] = new Property("Entries", PropertyType.INTEGER, (Object)new Integer(n3));
        int n4 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        int n5 = 3;
        propertyArray[1] = new Property("Components", PropertyType.INTEGER, (Object)new Integer(n4));
        int[] nArray = new int[n4];
        boolean[] blArray = new boolean[n4];
        for (int i = 0; i < n4; ++i) {
            n = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            blArray[i] = (n & 0x80) != 0;
            nArray[i] = (n & 0x7F) + 1;
        }
        n5 += n4;
        propertyArray[2] = new Property("BitDepth", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
        if (n3 > 1024 || n3 < 1) {
            propertyArray[3] = new Property("Values", PropertyType.STRING, (Object)"Invalid");
        } else {
            Property[] propertyArray2 = new Property[n4];
            for (n = 0; n < n4; ++n) {
                int[] nArray2 = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray2[i] = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
                }
                propertyArray2[n] = new Property("Component", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray2);
            }
            propertyArray[3] = new Property("Values", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray2);
            n5 += n4 * n3;
        }
        Property property = new Property("Palette", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
        if (this._parentBox instanceof CodestreamHeaderBox) {
            Codestream codestream = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            codestream.setPaletteProperty(property);
        } else {
            this._module.addProperty(property);
        }
        this._module.skipBytes(this._dstrm, (int)((long)n2 - (this._module.getFilePos() - l)), this._module);
        this.finalizeBytesRead();
        return true;
    }

    protected String getSelfPropName() {
        return "Palette Box";
    }
}

