/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeNode;
import org.openoffice.accessibility.awb.canvas.CanvasShape;
import org.openoffice.accessibility.awb.canvas.MouseObserver;
import org.openoffice.accessibility.awb.canvas.ShapeContainer;
import org.openoffice.accessibility.misc.Options;

public class Canvas
extends JPanel {
    public static final int WHOLE_SCREEN = -1;
    private int mnXAnchor;
    private int mnYAnchor;
    private int maResizeFlag;
    private double mnHOffset = 0.0;
    private double mnVOffset = 0.0;
    private double mnScale = 1.0;
    private CanvasShape maActiveObject;
    private JTree maTree = null;
    private Dimension maLastWidgetSize;
    private ShapeContainer maShapeList = new ShapeContainer(this);
    private MouseObserver maMouseObserver = new MouseObserver(this);

    public Canvas() {
        super(true);
        this.maLastWidgetSize = new Dimension(0, 0);
    }

    public void SetTree(JTree jTree) {
        if (jTree != this.maTree) {
            this.maTree = jTree;
            this.maShapeList.SetTree(this.maTree);
            this.maMouseObserver.SetTree(this.maTree);
        }
    }

    private void Clear() {
        this.maShapeList.Clear();
    }

    public Iterator GetShapeIterator() {
        return this.maShapeList.GetIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (Options.GetBoolean("Antialiasing")) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.setupTransformation();
            graphics2D.translate(this.mnHOffset, this.mnVOffset);
            graphics2D.scale(this.mnScale, this.mnScale);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
            graphics2D.setColor(new Color(250, 240, 230));
            graphics2D.fill(double_);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(double_);
            ShapeContainer shapeContainer = this.maShapeList;
            synchronized (shapeContainer) {
                Iterator iterator = this.maShapeList.GetIterator();
                boolean bl = Options.GetBoolean("ShowDescriptions");
                boolean bl2 = Options.GetBoolean("ShowNames");
                boolean bl3 = Options.GetBoolean("ShowText");
                while (iterator.hasNext()) {
                    CanvasShape canvasShape = (CanvasShape)iterator.next();
                    try {
                        canvasShape.paint(graphics2D, bl, bl2, bl3);
                    }
                    catch (Exception exception) {
                        System.err.println("caught exception while painting a shape:" + exception);
                        exception.printStackTrace(System.err);
                    }
                }
            }
            if (this.maActiveObject != null) {
                this.maActiveObject.paint_highlight(graphics2D);
            }
        }
    }

    private void setupTransformation() {
        JViewport jViewport = (JViewport)this.getParent();
        JScrollPane jScrollPane = (JScrollPane)jViewport.getParent();
        int n = Options.GetInteger("ZoomMode", -1);
        if (n == -1) {
            if (jScrollPane.getHorizontalScrollBarPolicy() != 31) {
                jScrollPane.setHorizontalScrollBarPolicy(31);
            }
            if (jScrollPane.getVerticalScrollBarPolicy() != 21) {
                jScrollPane.setVerticalScrollBarPolicy(21);
            }
        } else {
            if (jScrollPane.getHorizontalScrollBarPolicy() != 30) {
                jScrollPane.setHorizontalScrollBarPolicy(30);
            }
            if (jScrollPane.getVerticalScrollBarPolicy() != 20) {
                jScrollPane.setVerticalScrollBarPolicy(20);
            }
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jViewport.getSize();
        if (dimension.getWidth() > 0.0 && dimension.getHeight() > 0.0) {
            double d;
            double d2;
            this.mnScale = n == -1 ? ((d2 = (dimension2.getWidth() - 10.0) / dimension.getWidth()) < (d = (dimension2.getHeight() - 10.0) / dimension.getHeight()) ? d2 : d) : (double)n / 100.0;
            this.mnHOffset = (dimension2.getWidth() - this.mnScale * dimension.getWidth()) / 2.0;
            this.mnVOffset = (dimension2.getHeight() - this.mnScale * dimension.getHeight()) / 2.0;
            if (this.mnHOffset < 0.0) {
                this.mnHOffset = 0.0;
            }
            if (this.mnVOffset < 0.0) {
                this.mnVOffset = 0.0;
            }
            this.setPreferredSize(new Dimension((int)(2.0 * this.mnHOffset + this.mnScale * dimension.getWidth()), (int)(2.0 * this.mnVOffset + this.mnScale * dimension.getHeight())));
            this.revalidate();
        } else {
            this.mnScale = 1.0;
            this.mnHOffset = 0.0;
            this.mnVOffset = 0.0;
        }
        this.maLastWidgetSize = dimension2;
    }

    protected boolean HighlightObject(CanvasShape canvasShape) {
        if (canvasShape != this.maActiveObject) {
            if (this.maActiveObject != null) {
                this.maActiveObject.Highlight(false);
            }
            this.maActiveObject = canvasShape;
            if (this.maActiveObject != null) {
                this.maActiveObject.Highlight(true);
            }
            this.repaint();
            return true;
        }
        return false;
    }

    public void SelectObject(TreeNode treeNode) {
        CanvasShape canvasShape = this.maShapeList.Get(treeNode);
        this.HighlightObject(canvasShape);
    }
}

