/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.awb.tree.AccessibilityNode;

public class ToolkitNode
extends DefaultMutableTreeNode
implements XTopWindowListener {
    protected XExtendedToolkit xToolkit;
    private AccessibilityModel treeModel;

    public ToolkitNode(XExtendedToolkit xExtendedToolkit, AccessibilityModel accessibilityModel) {
        super("<connected>");
        this.xToolkit = xExtendedToolkit;
        this.treeModel = accessibilityModel;
        try {
            int n = xExtendedToolkit.getTopWindowCount();
            for (int i = 0; i < n; ++i) {
                AccessibilityNode accessibilityNode;
                XTopWindow xTopWindow = xExtendedToolkit.getTopWindow(i);
                if (xTopWindow == null || (accessibilityNode = this.getTopWindowNode(xTopWindow)) == null) continue;
                this.add(accessibilityNode);
                accessibilityNode.setAttached(true);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private AccessibilityNode getTopWindowNode(XAccessible xAccessible) {
        short s;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext != null && ((s = xAccessibleContext.getAccessibleRole()) == 21 || s == 12 || s == 67)) {
            return this.treeModel.createWindowNode(xAccessible, xAccessibleContext);
        }
        return null;
    }

    private AccessibilityNode getTopWindowNode(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        short s;
        if (xAccessibleContext != null && ((s = xAccessibleContext.getAccessibleRole()) == 21 || s == 12 || s == 67)) {
            AccessibilityNode accessibilityNode = this.treeModel.createWindowNode(xAccessible, xAccessibleContext);
            if (accessibilityNode != null) {
                try {
                    int n = xAccessibleContext.getAccessibleChildCount();
                    for (int i = 0; i < n; ++i) {
                        AccessibilityNode accessibilityNode2 = this.treeModel.createNode(xAccessibleContext.getAccessibleChild(i));
                        if (accessibilityNode2 == null) continue;
                        accessibilityNode.add(accessibilityNode2);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return accessibilityNode;
        }
        return null;
    }

    private AccessibilityNode getTopWindowNode(XTopWindow xTopWindow) {
        XAccessibleContext xAccessibleContext;
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xTopWindow);
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            XAccessible xAccessible2 = xAccessibleContext.getAccessibleParent();
            if (xAccessible2 != null) {
                AccessibilityNode accessibilityNode = this.getTopWindowNode(xAccessible2);
                AccessibilityNode accessibilityNode2 = this.treeModel.createNode(xAccessible);
                if (accessibilityNode != null && accessibilityNode2 != null) {
                    accessibilityNode.add(accessibilityNode2);
                }
                return accessibilityNode;
            }
            return this.getTopWindowNode(xAccessible, xAccessibleContext);
        }
        return null;
    }

    public void disposing(EventObject eventObject) {
        this.xToolkit = null;
        this.treeModel.setRoot(AccessibilityModel.disconnectedRootNode);
    }

    public void windowActivated(EventObject eventObject) {
    }

    public void windowClosed(EventObject eventObject) {
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)eventObject.Source);
        if (xAccessible != null) {
            AccessibilityNode accessibilityNode = this.treeModel.findNode(xAccessible);
            if (accessibilityNode != null && accessibilityNode.getParent() != this) {
                accessibilityNode = (AccessibilityNode)accessibilityNode.getParent();
            }
            if (accessibilityNode != null) {
                final AccessibilityNode accessibilityNode2 = accessibilityNode;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ToolkitNode.this.treeModel.removeNodeFromParent(accessibilityNode2);
                            accessibilityNode2.setAttached(false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void windowClosing(EventObject eventObject) {
    }

    public void windowDeactivated(EventObject eventObject) {
    }

    public void windowMinimized(EventObject eventObject) {
    }

    public void windowNormalized(EventObject eventObject) {
    }

    public void windowOpened(EventObject eventObject) {
        final XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)eventObject.Source);
        if (xTopWindow != null) {
            final ToolkitNode toolkitNode = this;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AccessibilityNode accessibilityNode = ToolkitNode.this.getTopWindowNode(xTopWindow);
                    if (accessibilityNode != null) {
                        ToolkitNode.this.treeModel.addNodeInto(accessibilityNode, toolkitNode);
                        accessibilityNode.setAttached(true);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

