/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;

public class ServiceInterfaceView
extends ObjectView {
    private JTree maTree;
    private DefaultMutableTreeNode maImplementationNameRoot = new DefaultMutableTreeNode("Implementation Name");
    private DefaultMutableTreeNode maServiceRoot = new DefaultMutableTreeNode("Supported Services");
    private DefaultMutableTreeNode maInterfaceRoot = new DefaultMutableTreeNode("Supported Interfaces");

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            return new ServiceInterfaceView(objectViewContainer);
        }
        return null;
    }

    public ServiceInterfaceView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        this.maTree = new JTree(new DefaultMutableTreeNode[]{this.maServiceRoot, this.maInterfaceRoot});
        JScrollPane jScrollPane = new JScrollPane(this.maTree, 20, 30);
        this.setMinimumSize(new Dimension(300, 200));
        this.setLayout(new GridLayout(1, 1));
        this.add(jScrollPane);
    }

    @Override
    public void Update() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.maTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        this.CreateImplementationNameTree();
        this.CreateServiceTree();
        this.CreateInterfaceTree();
        defaultMutableTreeNode.add(this.maImplementationNameRoot);
        defaultMutableTreeNode.add(this.maServiceRoot);
        defaultMutableTreeNode.add(this.maInterfaceRoot);
        defaultTreeModel.setRoot(defaultMutableTreeNode);
        for (int i = 0; i < this.maTree.getRowCount(); ++i) {
            this.maTree.expandRow(i);
        }
    }

    private void CreateImplementationNameTree() {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.mxContext);
        this.maImplementationNameRoot.removeAllChildren();
        if (xServiceInfo != null) {
            this.maImplementationNameRoot.add(new DefaultMutableTreeNode(xServiceInfo != null ? xServiceInfo.getImplementationName() : "<XServiceInfo not supported>"));
        }
    }

    private void CreateServiceTree() {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.mxContext);
        this.maServiceRoot.removeAllChildren();
        if (xServiceInfo != null) {
            String[] stringArray = xServiceInfo.getSupportedServiceNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.maServiceRoot.add(new DefaultMutableTreeNode(stringArray[i]));
            }
        } else {
            this.maServiceRoot.add(new DefaultMutableTreeNode("XServiceInfo not supported"));
        }
    }

    private void CreateInterfaceTree() {
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)this.mxContext);
        this.maInterfaceRoot.removeAllChildren();
        if (xTypeProvider != null) {
            Type[] typeArray = xTypeProvider.getTypes();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                this.maInterfaceRoot.add(new DefaultMutableTreeNode(typeArray[i].getTypeName()));
            }
        } else {
            this.maInterfaceRoot.add(new DefaultMutableTreeNode("XTypeProvider not supported"));
        }
    }

    @Override
    public String GetTitle() {
        return "Supported Services and Interfaces";
    }
}

