/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.misc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeDescriptor;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintStream;

public class InformationWriter {
    private PrintStream maOut;

    public InformationWriter(PrintStream printStream) {
        this.maOut = printStream;
    }

    public void drawPageTest(XInterface xInterface) {
        try {
            this.printProperty(xInterface, "BorderBottom  ", "BorderBottom");
            this.printProperty(xInterface, "BorderLeft    ", "BorderLeft");
            this.printProperty(xInterface, "BorderRight   ", "BorderRight");
            this.printProperty(xInterface, "BorderTop     ", "BorderTop");
            this.printProperty(xInterface, "Height        ", "Height");
            this.printProperty(xInterface, "Width         ", "Width");
            this.printProperty(xInterface, "Number        ", "Number");
        }
        catch (Exception exception) {
            System.out.println("caught exception while testing draw page:" + exception);
        }
    }

    public void printProperty(XInterface xInterface, String string, String string2) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            this.maOut.println(string + xPropertySet.getPropertyValue(string2));
        }
        catch (Exception exception) {
            this.maOut.println("caught exception while getting property " + string2 + " : " + exception);
        }
    }

    public void showShapes(XDrawPage xDrawPage) {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPage);
            this.maOut.println("There are " + xIndexAccess.getCount() + " shapes");
            for (int i = 0; i < xIndexAccess.getCount(); ++i) {
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xIndexAccess.getByIndex(i));
                XShapeDescriptor xShapeDescriptor = (XShapeDescriptor)UnoRuntime.queryInterface(XShapeDescriptor.class, (Object)xShape);
                String string = xShapeDescriptor.getShapeType();
                this.maOut.println("   shape " + i + " : " + string);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape);
                Integer n = (Integer)xPropertySet.getPropertyValue("ZOrder");
                this.maOut.println("   zorder = " + n);
            }
        }
        catch (Exception exception) {
            this.maOut.println("caught exception in showShapes: " + exception);
        }
    }

    public void showServices(XInterface xInterface) {
        try {
            this.maOut.println("Services:");
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xInterface);
            if (xMultiServiceFactory == null) {
                this.maOut.println("    object does not support interface XMultiServiceFactory");
            } else {
                String[] stringArray = xMultiServiceFactory.getAvailableServiceNames();
                this.maOut.println("    object can create " + stringArray.length + " services");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.maOut.println("        service " + i + " : " + stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            this.maOut.println("caught exception in showServices : " + exception);
        }
    }

    public void showInfo(XInterface xInterface) {
        try {
            System.out.println("Info:");
            XServiceName xServiceName = (XServiceName)UnoRuntime.queryInterface(XServiceName.class, (Object)xInterface);
            if (xServiceName == null) {
                this.maOut.println("    interface XServiceName not supported");
            } else {
                this.maOut.println("    Service name        : " + xServiceName.getServiceName());
            }
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xInterface);
            if (xServiceInfo == null) {
                this.maOut.println("    interface XServiceInfo not supported");
            } else {
                this.maOut.println("    Implementation name : " + xServiceInfo.getImplementationName());
            }
        }
        catch (Exception exception) {
            this.maOut.println("caught exception in showInfo : " + exception);
        }
    }

    public void showInterfaces(XInterface xInterface) {
        try {
            this.maOut.println("Interfaces:");
            XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)xInterface);
            if (xTypeProvider == null) {
                this.maOut.println("    interface XTypeProvider not supported");
            } else {
                Type[] typeArray = xTypeProvider.getTypes();
                this.maOut.println("    object supports " + typeArray.length + " interfaces");
                for (int i = 0; i < typeArray.length; ++i) {
                    this.maOut.println("        " + i + " : " + typeArray[i].getTypeName());
                }
            }
        }
        catch (Exception exception) {
            this.maOut.println("caught exception in showInterfaces : " + exception);
        }
    }

    public boolean showAccessibility(XInterface xInterface, int n) {
        try {
            String string = "";
            while (n-- > 0) {
                string = string + "    ";
            }
            XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)xInterface);
            if (xAccessibleContext == null) {
                XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xInterface);
                if (xAccessible == null) {
                    this.maOut.println(string + "given object " + xInterface + " is not accessible");
                    return false;
                }
                xAccessibleContext = xAccessible.getAccessibleContext();
            }
            if (xAccessibleContext != null) {
                this.maOut.println(string + "Name         : " + xAccessibleContext.getAccessibleName());
                this.maOut.println(string + "Description  : " + xAccessibleContext.getAccessibleDescription());
                this.maOut.println(string + "Role         : " + xAccessibleContext.getAccessibleRole());
                if (xAccessibleContext.getAccessibleParent() != null) {
                    this.maOut.println(string + "Has parent   : yes");
                    this.maOut.println(string + "Parent index : " + xAccessibleContext.getAccessibleIndexInParent());
                } else {
                    this.maOut.println(string + "Has parent   : no");
                }
                this.maOut.println(string + "Child count  : " + xAccessibleContext.getAccessibleChildCount());
                this.maOut.print(string + "Relation set : ");
                XAccessibleRelationSet xAccessibleRelationSet = xAccessibleContext.getAccessibleRelationSet();
                if (xAccessibleRelationSet != null) {
                    this.maOut.print(xAccessibleRelationSet.getRelationCount() + " (");
                    for (int i = 0; i < xAccessibleRelationSet.getRelationCount(); ++i) {
                        if (i > 0) {
                            this.maOut.print(", ");
                        }
                        this.maOut.print(xAccessibleRelationSet.getRelation(i).toString());
                    }
                    this.maOut.println(")");
                } else {
                    this.maOut.println("no relation set");
                }
                this.maOut.print(string + "State set    : ");
                XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
                if (xAccessibleStateSet != null) {
                    XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xAccessibleStateSet);
                    this.maOut.print(xIndexAccess.getCount() + " (");
                    for (int i = 0; i < xIndexAccess.getCount(); ++i) {
                        if (i > 0) {
                            this.maOut.print(", ");
                        }
                        this.maOut.print(xIndexAccess.getByIndex(i).toString());
                    }
                    this.maOut.println(")");
                } else {
                    this.maOut.println("no state set");
                }
                this.showAccessibleComponent((XInterface)xAccessibleContext, string);
            } else {
                this.maOut.println("object has no accessible context.");
            }
        }
        catch (Exception exception) {
            System.out.println("caught exception in showAccessibility :" + exception);
        }
        return true;
    }

    public void showAccessibleComponent(XInterface xInterface, String string) {
        try {
            XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xInterface);
            if (xAccessibleComponent != null) {
                this.maOut.println(string + "Position        : " + xAccessibleComponent.getLocation().X + ", " + xAccessibleComponent.getLocation().Y);
                this.maOut.println(string + "Screen position : " + xAccessibleComponent.getLocationOnScreen().X + ", " + xAccessibleComponent.getLocationOnScreen().Y);
                this.maOut.println(string + "Size            : " + xAccessibleComponent.getSize().Width + ", " + xAccessibleComponent.getSize().Height);
            }
        }
        catch (Exception exception) {
            System.out.println("caught exception in showAccessibleComponent : " + exception);
        }
    }

    public boolean showAccessibilityTree(XAccessible xAccessible, int n) {
        try {
            if (!this.showAccessibility((XInterface)xAccessible, n)) {
                return false;
            }
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + "    ";
            }
            XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
            if (xAccessibleContext != null) {
                int n2 = xAccessibleContext.getAccessibleChildCount();
                for (int i = 0; i < n2; ++i) {
                    this.maOut.println(string + "child " + i + " :");
                    this.showAccessibilityTree(xAccessibleContext.getAccessibleChild(i), n + 1);
                }
            } else {
                this.maOut.println("Accessible object has no context");
            }
        }
        catch (Exception exception) {
            System.out.println("caught exception in showAccessibleTree : " + exception);
            return false;
        }
        return true;
    }

    public void showProperties(XInterface xInterface) {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
        if (xPropertySet == null) {
            this.maOut.println("object does not support XPropertySet");
        } else {
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            int n = propertyArray.length;
            for (int i = 0; i < n; ++i) {
                this.maOut.println(i + " : " + propertyArray[i].Name + ", " + propertyArray[i].Type);
            }
        }
    }
}

