/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleExtendedComponent;
import com.sun.star.accessibility.XAccessibleKeyBinding;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Selection;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleKeyBinding;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public abstract class Component
extends java.awt.Component {
    public static final Type RectangleType = new Type(Rectangle.class);
    public static final Type SelectionType = new Type(Selection.class);
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent;
    protected boolean disposed = false;
    protected AccessibleContext accessibleContext = null;

    protected Component(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(this.createEventListener());
        }
    }

    @Override
    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    @Override
    public void addNotify() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public boolean requestFocus(boolean bl) {
        return true;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    @Override
    protected boolean requestFocusInWindow(boolean bl) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, bl));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] objectArray) {
        try {
            ArrayList<java.awt.Component> arrayList = new ArrayList<java.awt.Component>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                java.awt.Component component = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)objectArray[i]));
                if (component == null) continue;
                arrayList.add(component);
            }
            arrayList.trimToSize();
            return arrayList.toArray();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getEventQueue();
        EventQueue.invokeLater(new PropertyChangeBroadcaster(string, object, object2));
    }

    protected void fireStatePropertyChange(AccessibleState accessibleState, boolean bl) {
        PropertyChangeBroadcaster propertyChangeBroadcaster = bl ? new PropertyChangeBroadcaster("AccessibleState", null, accessibleState) : new PropertyChangeBroadcaster("AccessibleState", accessibleState, null);
        this.getEventQueue();
        EventQueue.invokeLater(propertyChangeBroadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleUNOComponentListener();
    }

    protected AccessibleContext createAccessibleContext() {
        return null;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext accessibleContext = this.createAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    accessibleContext.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = accessibleContext;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public static Number toNumber(Object object) {
        try {
            if (AnyConverter.isByte((Object)object)) {
                return new Byte(AnyConverter.toByte((Object)object));
            }
            if (AnyConverter.isShort((Object)object)) {
                return new Short(AnyConverter.toShort((Object)object));
            }
            if (AnyConverter.isInt((Object)object)) {
                return new Integer(AnyConverter.toInt((Object)object));
            }
            if (AnyConverter.isLong((Object)object)) {
                return new Long(AnyConverter.toLong((Object)object));
            }
            if (AnyConverter.isFloat((Object)object)) {
                return new Float(AnyConverter.toFloat((Object)object));
            }
            if (AnyConverter.isDouble((Object)object)) {
                return new Double(AnyConverter.toDouble((Object)object));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new java.lang.IllegalArgumentException(illegalArgumentException.getMessage());
        }
        return null;
    }

    @Override
    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    protected abstract class AccessibleUNOComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleExtendedComponent {
        protected ComponentListener accessibleComponentHandler;
        protected FocusListener accessibleFocusHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleUNOComponent() {
            super(Component.this);
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Component.this.addComponentListener(this.accessibleComponentHandler);
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                Component.this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Component.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Component.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (Component.this.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(Component.this, Component.this.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException runtimeException) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        @Override
        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale locale = Component.this.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(locale.Language, locale.Country);
            }
            catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                return java.util.Locale.getDefault();
            }
        }

        @Override
        public Color getBackground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return Component.this.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return Component.this.isShowing();
        }

        @Override
        public boolean contains(java.awt.Point point) {
            try {
                return Component.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Component.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public java.awt.Point getLocation() {
            try {
                Point point = Component.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setLocation(java.awt.Point point) {
        }

        @Override
        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Component.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setBounds(java.awt.Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            try {
                Size size = Component.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(java.awt.Point point) {
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return Component.this.isFocusable();
        }

        @Override
        public void requestFocus() {
            Component.this.unoAccessibleComponent.grabFocus();
        }

        @Override
        public String getToolTipText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface(XAccessibleExtendedComponent.class, (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getToolTipText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        @Override
        public String getTitledBorderText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface(XAccessibleExtendedComponent.class, (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getTitledBorderText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        @Override
        public javax.accessibility.AccessibleKeyBinding getAccessibleKeyBinding() {
            try {
                XAccessibleKeyBinding xAccessibleKeyBinding;
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleAction != null && (xAccessibleKeyBinding = xAccessibleAction.getAccessibleActionKeyBinding(0)) != null) {
                    return new AccessibleKeyBinding(xAccessibleKeyBinding);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleUNOComponentListener
    implements XAccessibleEventListener {
        protected AccessibleUNOComponentListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    break;
                }
                case 2: {
                    Component.this.fireStatePropertyChange(AccessibleState.ARMED, bl);
                    break;
                }
                case 4: {
                    Component.this.fireStatePropertyChange(AccessibleState.CHECKED, bl);
                    break;
                }
                case 7: {
                    Component.this.setEnabled(bl);
                    Component.this.fireStatePropertyChange(AccessibleState.ENABLED, bl);
                    break;
                }
                case 11: {
                    Component.this.getEventQueue().postEvent(new FocusEvent(Component.this, bl ? 1004 : 1005));
                    break;
                }
                case 20: {
                    Component.this.fireStatePropertyChange(AccessibleState.PRESSED, bl);
                    break;
                }
                case 23: {
                    Component.this.fireStatePropertyChange(AccessibleState.SELECTED, bl);
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 30: {
                    Component.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            if (!Component.this.disposed) {
                switch (accessibleEventObject.EventId) {
                    case 3: {
                        AccessibleContext cfr_ignored_0 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("accessibleActionProperty", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 1: {
                        this.handleNameChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        Component.this.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 22: {
                        Component.this.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(accessibleEventObject.OldValue), AccessibleTextImpl.convertTextSegment(accessibleEventObject.NewValue));
                        break;
                    }
                    case 21: {
                        Component.this.firePropertyChange("AccessibleSelection", null, null);
                        break;
                    }
                    case 20: {
                        AccessibleContext cfr_ignored_1 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("AccessibleCaret", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 11: {
                        AccessibleContext cfr_ignored_2 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("AccessibleValue", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            Component.this.disposed = true;
            AccessibleObjectFactory.disposing(Component.this);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(String string, Object object, Object object2) {
            this.propertyName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        @Override
        public void run() {
            try {
                AccessibleContext accessibleContext = Component.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

