/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.NoSuitableClassLoaderException;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.javascript.ScriptEditorForJavaScript;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

class ScriptImpl
implements XScript {
    private ScriptMetaData metaData;
    private XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private XModel m_xModel;
    private XScriptInvocationContext m_xInvocContext;

    ScriptImpl(XComponentContext xComponentContext, ScriptMetaData scriptMetaData, XModel xModel, XScriptInvocationContext xScriptInvocationContext) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        this.m_xInvocContext = xScriptInvocationContext;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            LogUtils.DEBUG(LogUtils.getTrace(exception));
            throw new RuntimeException("Error constructing  ScriptImpl: [javascript]");
        }
        LogUtils.DEBUG("ScriptImpl [javascript] script data = " + scriptMetaData);
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, InvocationTargetException {
        Object object;
        Object object2;
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            classLoader = ClassLoaderFactory.getURLClassLoader(this.metaData);
            uRL = this.metaData.getSourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ScriptFrameworkErrorException(malformedURLException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        catch (NoSuitableClassLoaderException noSuitableClassLoaderException) {
            throw new ScriptFrameworkErrorException(noSuitableClassLoaderException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        Context context = null;
        try {
            String string = uRL.toString();
            object2 = null;
            String string2 = null;
            object = ScriptEditorForJavaScript.getEditor(this.metaData.getSourceURL());
            if (object != null) {
                string = ((ScriptEditorForJavaScript)object).getURL();
                object2 = ((ScriptEditorForJavaScript)object).execute();
                if (object2 != null && object2.getClass().getName().equals("org.mozilla.javascript.Undefined")) {
                    String string3 = Context.toString(object2);
                    return string3;
                }
            }
            if (object != null && ((ScriptEditorForJavaScript)object).isModified()) {
                LogUtils.DEBUG("GOT A MODIFIED SOURCE");
                string2 = ((ScriptEditorForJavaScript)object).getText();
            } else {
                this.metaData.loadSource();
                string2 = this.metaData.getSource();
            }
            if (string2 == null || string2.length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read source data for script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            context = Context.enter();
            context.setLanguageVersion(180);
            context.setOptimizationLevel(9);
            ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject(ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory), importerTopLevel);
            importerTopLevel.put("XSCRIPTCONTEXT", (Scriptable)importerTopLevel, (Object)scriptable);
            Scriptable scriptable2 = Context.toObject(objectArray, importerTopLevel);
            importerTopLevel.put("ARGUMENTS", (Scriptable)importerTopLevel, (Object)scriptable2);
            object2 = context.evaluateString(importerTopLevel, string2, "<stdin>", 1, null);
            Object object3 = object2 = Context.toString(object2);
            return object3;
        }
        catch (JavaScriptException javaScriptException) {
            LogUtils.DEBUG("Caught JavaScriptException exception for JavaScript type = " + javaScriptException.getClass());
            object2 = javaScriptException.getMessage();
            int n = javaScriptException.lineNumber();
            object = javaScriptException.getValue();
            LogUtils.DEBUG("\t message  " + (String)object2);
            LogUtils.DEBUG("\t wrapped type " + object.getClass());
            LogUtils.DEBUG("\t wrapped toString  " + object.toString());
            ScriptExceptionRaisedException scriptExceptionRaisedException = new ScriptExceptionRaisedException((String)object2);
            scriptExceptionRaisedException.lineNum = n;
            scriptExceptionRaisedException.language = "JavaScript";
            scriptExceptionRaisedException.scriptName = this.metaData.getLanguageName();
            scriptExceptionRaisedException.exceptionType = object.getClass().getName();
            scriptExceptionRaisedException.language = this.metaData.getLanguage();
            LogUtils.DEBUG("ExceptionRaised exception  ");
            LogUtils.DEBUG("\t message  " + scriptExceptionRaisedException.getMessage());
            LogUtils.DEBUG("\t lineNum  " + scriptExceptionRaisedException.lineNum);
            LogUtils.DEBUG("\t language  " + scriptExceptionRaisedException.language);
            LogUtils.DEBUG("\t scriptName  " + scriptExceptionRaisedException.scriptName);
            this.raiseEditor(scriptExceptionRaisedException.lineNum);
            throw new InvocationTargetException("JavaScript uncaught exception" + this.metaData.getLanguageName(), null, (Object)scriptExceptionRaisedException);
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Caught Exception " + exception);
            LogUtils.DEBUG("rethrowing as ScriptFramework error");
            throw new ScriptFrameworkErrorException(exception.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        finally {
            if (context != null) {
                Context.exit();
            }
        }
    }

    private void raiseEditor(int n) {
        ScriptEditorForJavaScript scriptEditorForJavaScript = null;
        try {
            URL uRL = this.metaData.getSourceURL();
            scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor(uRL);
            if (scriptEditorForJavaScript == null) {
                scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor();
                scriptEditorForJavaScript.edit(ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory), this.metaData);
                scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor(uRL);
            }
            if (scriptEditorForJavaScript != null) {
                System.out.println("** Have raised IDE for JavaScript, calling indicateErrorLine for line " + n);
                scriptEditorForJavaScript.indicateErrorLine(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

