/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra;

import com.exlibris.digitool.common.forms.xmlbeans.XFields;
import com.exlibris.digitool.common.forms.xmlbeans.XFormDocument;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;

public class XmlbeansUtils {
    public static boolean isXFormValid(String paramsXml) {
        boolean isValid = true;
        try {
            if (StringUtils.isNotEmpty((String)paramsXml)) {
                XFormDocument.Factory.parse(paramsXml);
            }
        }
        catch (XmlException e) {
            isValid = false;
        }
        return isValid;
    }

    public static Map<String, String> getParamsFromXForm(String paramsXml) throws XmlException {
        XFormDocument xformDocument = null;
        xformDocument = XFormDocument.Factory.parse(paramsXml);
        XFields xFields = xformDocument.getXForm().getXFields();
        HashMap<String, String> map = new HashMap<String, String>();
        if (xformDocument.getXForm() != null && xFields != null && xFields.getXFieldArray() != null) {
            XFields.XField[] xfieldArr;
            for (XFields.XField xfield : xfieldArr = xFields.getXFieldArray()) {
                map.put(xfield.getFieldName(), xfield.getDefaultValue());
            }
        }
        return map;
    }

    public static String setParamsToXForm(String paramsXml, Map<String, String> paramsMap) throws XmlException {
        XFormDocument xformDocument = XFormDocument.Factory.parse(paramsXml);
        XFields xFields = xformDocument.getXForm().getXFields();
        if (paramsMap != null && !paramsMap.isEmpty() && xformDocument.getXForm() != null && xFields != null && xFields.getXFieldArray() != null) {
            XFields.XField[] xfieldArr;
            for (XFields.XField xfield : xfieldArr = xFields.getXFieldArray()) {
                String fieldName = xfield.getFieldName();
                String value = paramsMap.containsKey(fieldName) ? paramsMap.get(fieldName) : null;
                xfield.setDefaultValue(value);
            }
        }
        return xformDocument.toString();
    }
}

