/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.cache;

import com.exlibris.core.infra.common.cache.CacheItemDescription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.marshall.Region;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class CacheDiscover {
    private TreeCache cache;

    public CacheDiscover() throws Exception {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        this.cache = ((TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (String)"jboss.cache:service=TreeCache", (MBeanServer)server)).getInstance();
    }

    private void runThrowData(Node ch, ArrayList<CacheItemDescription> result) {
        Map data = ch.getData();
        if (data == null) {
            this.runThrowChildren(ch, result);
        } else {
            Set keys = data.keySet();
            for (Object key : keys) {
                Object value = data.get(key);
                String className = value != null ? value.getClass().getName() : "";
                String valueString = value != null ? value.toString() : "";
                result.add(new CacheItemDescription(ch.getFqn().getName(), key.toString(), className, valueString));
            }
        }
    }

    private void runThrowChildren(Node ch, ArrayList<CacheItemDescription> result) {
        Map childs = ch.getChildren();
        if (childs != null) {
            Iterator cc = childs.values().iterator();
            while (cc.hasNext()) {
                this.runThrowData((Node)cc.next(), result);
            }
        }
    }

    public List<CacheItemDescription> getListItemDescription() throws Exception {
        ArrayList<CacheItemDescription> result = new ArrayList<CacheItemDescription>();
        this.runThrowData(this.cache.get("/"), result);
        return result;
    }

    public void printCache() throws Exception {
        Region[] regions;
        for (Region r : regions = this.cache.getRegionManager().getRegions()) {
            String fqn = r.getFqn();
            Set keys = this.cache.getKeys(fqn);
            for (String key : keys) {
                Object att = this.cache.get(fqn, (Object)key);
                System.out.println("FQN=" + fqn + ",KEY=" + key + ",class=" + att.getClass().getName() + ",value=" + att.toString());
            }
        }
    }
}

