/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public final class IOUtil {
    public static final String UTF8_ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static ExLogger log = ExLogger.getExLogger(IOUtil.class);

    private IOUtil() {
    }

    public static void shutdownStream(OutputStream output) {
        if (null == output) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(InputStream input) {
        if (null == input) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOUtil.copy(input, output, 4096);
    }

    public static void copy(long contentLength, InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        int lengthToRead = 0;
        for (long remaining = contentLength; remaining > 0L && (n = input.read(buffer, 0, lengthToRead = remaining > 4096L ? 4096 : (int)remaining)) != -1; remaining -= (long)n) {
            output.write(buffer, 0, n);
        }
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            total += n;
        }
        return total;
    }

    public static void copy(Reader input, Writer output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyNIO(String srcPath, String destPath) {
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            srcChannel = new FileInputStream(srcPath).getChannel();
            dstChannel = new FileOutputStream(destPath).getChannel();
            ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
        }
        catch (IOException e) {
        }
        finally {
            try {
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(InputStream input, Writer output, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input, UTF8_ENCODING);
        IOUtil.copy((Reader)in, output, bufferSize);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtil.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtil.copy((Reader)in, output, bufferSize);
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtil.toString(input, 4096);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return IOUtil.toString(input, encoding, 4096);
    }

    public static String toString(InputStream input, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtil.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(InputStream input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(Reader input, OutputStream output, int bufferSize) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy(input, (Writer)out, bufferSize);
        out.flush();
    }

    public static String toString(Reader input) throws IOException {
        return IOUtil.toString(input, 4096);
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        return IOUtil.toString(input, bufferSize, 16);
    }

    public static String toString(Reader input, int bufferSize, int estimatedLength) throws IOException {
        StringWriter sw = new StringWriter(estimatedLength);
        IOUtil.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        return IOUtil.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(Reader input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(String input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(String input, OutputStream output, int bufferSize) throws IOException {
        StringReader in = new StringReader(input);
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy((Reader)in, (Writer)out, bufferSize);
        out.flush();
    }

    public static void copy(String input, Writer output) throws IOException {
        output.write(input);
    }

    @Deprecated
    public static void bufferedCopy(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        IOUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
    }

    public static byte[] toByteArray(String input) throws IOException {
        return IOUtil.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(String input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(byte[] input, Writer output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(byte[] input, Writer output, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtil.copy((InputStream)in, output, bufferSize);
    }

    public static void copy(byte[] input, Writer output, String encoding) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtil.copy((InputStream)in, output, encoding);
    }

    public static void copy(byte[] input, Writer output, String encoding, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtil.copy(in, output, encoding, bufferSize);
    }

    public static String toString(byte[] input) throws IOException {
        return IOUtil.toString(input, 4096);
    }

    public static String toString(byte[] input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(byte[] input, String encoding) throws IOException {
        return IOUtil.toString(input, encoding, 4096);
    }

    public static String toString(byte[] input, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static void copy(byte[] input, OutputStream output) throws IOException {
        IOUtil.copy(input, output, 4096);
    }

    public static void copy(byte[] input, OutputStream output, int bufferSize) throws IOException {
        output.write(input);
    }

    public static InputStream getResetSupportingInputStream(InputStream inputStream) throws IOException {
        if (inputStream.markSupported()) {
            return inputStream;
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(inputStream.available() + 1);
        IOUtil.copy(inputStream, (OutputStream)byteOutputStream);
        byte[] byteArr = byteOutputStream.toByteArray();
        ByteArrayInputStream newInStream = new ByteArrayInputStream(byteArr);
        return newInStream;
    }

    public static void deleteFile(String location) {
        File file = new File(location);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close the InputStream", e, new String[0]);
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close the OutputStream", e, new String[0]);
        }
    }

    public static void closeQuietly(InputStreamReader inputStreamReader) {
        try {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close the InputStreamReader", e, new String[0]);
        }
    }

    public static void closeQuietly(OutputStreamWriter output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close the OutputStream", e, new String[0]);
        }
    }
}

