/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.FormFieldInt;
import com.exlibris.core.infra.model.HDpFieldEvent;
import com.exlibris.core.infra.model.HDpFieldGeneralParameter;
import com.exlibris.core.infra.model.HDpFieldMode;
import com.exlibris.core.infra.model.HDpFieldOption;
import com.exlibris.core.infra.model.HDpFieldPopulatorParameter;
import com.exlibris.core.infra.model.HDpFieldValidatorParameter;
import com.exlibris.core.infra.model.HDpForm;
import com.exlibris.core.infra.model.HPersistent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@AttributeOverride(column=@Column(name="id"), name="id")
public class HDpFormField
extends HPersistent
implements FormFieldInt {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NAME_FOR_CODE_TABLE = "table";
    public static final String NO_MAPPING = "no_mapping";
    public static final String PREFIX_DELIMITER = ":";
    public static final String INPUT_NAME_PREFIX = "formField_";
    public static final String POPULATOR_CLASS_NAME = "com.exlibris.core.infra.web.utils.formBuilder.populators.CodeTablePopulator";
    private String fieldName;
    private String mdTargetName;
    private String mdCustomTarget;
    private int logicType;
    private FormFieldDataType dataType;
    private int posX;
    private int posY;
    private String label;
    private String uiDescription;
    private String uiExplanationText;
    private String idStr;
    private String uiToolTip;
    private int uiType = 1;
    private String initialDefaultValue;
    private String defaultValue;
    private String codeTableName;
    private boolean mandatory;
    private String validatorClassName = "0";
    private boolean valid = true;
    private boolean readOnly;
    private boolean hidden;
    private int orderInList;
    private int fieldSize;
    private boolean single;
    private List<HDpFieldOption> options = new ArrayList<HDpFieldOption>();
    private List<HDpFieldOption> initialOptions = new ArrayList<HDpFieldOption>();
    private List<HDpFieldMode> modes = new ArrayList<HDpFieldMode>();
    private String populatorClassName;
    private List<HDpFieldPopulatorParameter> populatorParamList = new ArrayList<HDpFieldPopulatorParameter>();
    private List<HDpFieldValidatorParameter> validatorParamList = new ArrayList<HDpFieldValidatorParameter>();
    private List<HDpFieldGeneralParameter> generalParamList = new ArrayList<HDpFieldGeneralParameter>();
    private List<HDpFieldEvent> eventsList = new ArrayList<HDpFieldEvent>();
    private String fieldCode;
    private String codeValue;
    private String urlTemplate;
    private String cssClass;
    private String rolesInclude;
    private boolean visibleDefaultValue = true;
    private String visibleFieldName = null;
    private boolean visiblePlaceHolder = true;
    private String fieldValue;
    private HDpFormField attachedField = null;
    private String labelCssClassl;
    private Integer displayedLength;
    private boolean isInternal = false;
    private HDpForm form;

    @Transient
    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    @Transient
    public String getIdStr() {
        return this.getId().toString();
    }

    public void setIdStr(String idStr) {
        if (idStr != null) {
            this.idStr = idStr.trim();
        }
    }

    @Override
    public int getLogicType() {
        return this.logicType;
    }

    public void setLogicType(int logicType) {
        this.logicType = logicType;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getUiDescription() {
        if (this.uiDescription == null) {
            return this.getFieldName();
        }
        return this.uiDescription;
    }

    public void setUiDescription(String uiDescription) {
        if (uiDescription != null) {
            this.uiDescription = uiDescription.trim();
        }
    }

    public String getUiExplanationText() {
        return this.uiExplanationText;
    }

    public void setUiExplanationText(String uiExplanationText) {
        if (uiExplanationText != null) {
            this.uiExplanationText = uiExplanationText.trim();
        }
    }

    @Override
    public String getUiToolTip() {
        return this.uiToolTip;
    }

    public void setUiToolTip(String uiToolTip) {
        if (uiToolTip != null) {
            this.uiToolTip = uiToolTip.trim();
        }
    }

    @Override
    public int getUiType() {
        return this.uiType;
    }

    public void setUiType(int uiType) {
        this.uiType = uiType;
    }

    @Override
    @Column(length=2048)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        if (fieldName != null) {
            this.fieldName = fieldName.trim();
        }
    }

    public static String formatFieldName(HDpFormField fld) {
        String nn = INPUT_NAME_PREFIX + fld.getId();
        return nn;
    }

    public static String unformatFieldName(String name) {
        String nn = null;
        if (name.startsWith(INPUT_NAME_PREFIX)) {
            nn = name.replaceFirst(INPUT_NAME_PREFIX, "");
        }
        return nn;
    }

    @Enumerated
    public FormFieldDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(FormFieldDataType dataType) {
        this.dataType = dataType;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != null) {
            this.label = label.trim();
        }
    }

    public void setForm(HDpForm form) {
        this.form = form;
    }

    @ManyToOne(targetEntity=HDpForm.class)
    @JoinColumn(name="form_id", updatable=false)
    public HDpForm getForm() {
        return this.form;
    }

    public Object cloneObject() {
        List<HDpFieldGeneralParameter> parameters;
        HDpFormField fld = new HDpFormField();
        fld.setFieldName(this.getFieldName());
        fld.setFieldValue(this.getFieldValue());
        fld.setDefaultValue(this.getDefaultValue());
        fld.setInitialDefaultValue(this.getInitialDefaultValue());
        fld.setLogicType(this.getLogicType());
        fld.setMandatory(this.getMandatory());
        fld.setUiDescription(this.getUiDescription());
        fld.setLabel(this.getLabel());
        fld.setUiExplanationText(this.getUiExplanationText());
        fld.setUiToolTip(this.getUiToolTip());
        fld.setUiType(this.getUiType());
        fld.setReadOnly(this.isReadOnly());
        fld.setValidatorClassName(this.getValidatorClassName());
        fld.setMdTargetName(this.getMdTargetName());
        fld.setCodeTableName(this.getCodeTableName());
        fld.setOrderInList(this.getOrderInList());
        fld.setLabelCssClassl(this.getLabelCssClassl());
        fld.setDisplayedLength(this.getDisplayedLength());
        fld.setVisibleDefaultValue(this.isVisibleDefaultValue());
        fld.setVisibleFieldName(this.getVisibleFieldName());
        fld.setVisiblePlaceHolder(this.isVisiblePlaceHolder());
        if (this.getOptions() != null) {
            for (HDpFieldOption option : this.getOptions()) {
                fld.addOption(option.cloneObject());
            }
        }
        if (this.getInitialOptions() != null) {
            for (HDpFieldOption option : this.getInitialOptions()) {
                fld.addInitalOption(option.cloneObject());
            }
        }
        fld.setModes(this.getModes());
        List<HDpFieldMode> modes = this.getModes();
        if (modes != null) {
            for (HDpFieldMode dpFieldMode : modes) {
                fld.addMode((HDpFieldMode)dpFieldMode.cloneObject());
            }
        }
        if ((parameters = this.getGeneralParamList()) != null) {
            for (HDpFieldGeneralParameter dpFieldGeneralParameter : parameters) {
                fld.addGeneralParam((HDpFieldGeneralParameter)dpFieldGeneralParameter.cloneObject());
            }
        }
        return fld;
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="formfield_id")
    @Cascade(value={CascadeType.ALL})
    @OrderBy(value="orderInList")
    public List<HDpFieldOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<HDpFieldOption> options) {
        this.options = options;
    }

    public int getOrderInList() {
        return this.orderInList;
    }

    public void setOrderInList(int orderInList) {
        this.orderInList = orderInList;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof HDpFormField) {
            HDpFormField mdFormField = (HDpFormField)o;
            if (this.getId() == null || mdFormField.getId() == null) {
                return false;
            }
            return this.getId().equals(mdFormField.getId());
        }
        return false;
    }

    public HDpFormField addOption(HDpFieldOption option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
        return this;
    }

    public HDpFormField addInitalOption(HDpFieldOption option) {
        if (!this.initialOptions.contains(option)) {
            this.initialOptions.add(option);
        }
        return this;
    }

    @Override
    public int getFieldSize() {
        return this.fieldSize;
    }

    public void setFieldSize(int size) {
        this.fieldSize = size;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public String getMdTargetName() {
        return this.mdTargetName;
    }

    public void setMdTargetName(String mdTargetName) {
        this.mdTargetName = mdTargetName;
    }

    public String getMdCustomTarget() {
        return this.mdCustomTarget;
    }

    public void setMdCustomTarget(String mdCustomTarget) {
        this.mdCustomTarget = mdCustomTarget;
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public void setValidatorClassName(String validatorClassName) {
        if (validatorClassName != null) {
            this.validatorClassName = validatorClassName.trim();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getPopulatorClassName() {
        return this.populatorClassName;
    }

    public void setPopulatorClassName(String populatorClassName) {
        this.populatorClassName = populatorClassName != null ? populatorClassName.trim() : null;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="formfield_id")
    @Cascade(value={CascadeType.ALL})
    public List<HDpFieldPopulatorParameter> getPopulatorParamList() {
        return this.populatorParamList;
    }

    public void setPopulatorParamList(List<HDpFieldPopulatorParameter> populatorParamList) {
        this.populatorParamList = populatorParamList;
    }

    public HDpFormField addPopulatorParameter(HDpFieldPopulatorParameter param) {
        if (!this.populatorParamList.contains(param)) {
            this.populatorParamList.add(param);
        }
        return this;
    }

    @Transient
    public Map<String, String> getPopulatorParamMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.populatorParamList.size(); ++i) {
            String key = this.populatorParamList.get(i).getName();
            String value = this.populatorParamList.get(i).getValue();
            map.put(key, value);
        }
        return map;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="formfield_id")
    @Cascade(value={CascadeType.ALL})
    public List<HDpFieldValidatorParameter> getValidatorParamList() {
        return this.validatorParamList;
    }

    public void setValidatorParamList(List<HDpFieldValidatorParameter> populatorParamList) {
        this.validatorParamList = populatorParamList;
    }

    public HDpFormField addValidatorParameter(HDpFieldValidatorParameter param) {
        if (!this.validatorParamList.contains(param)) {
            this.validatorParamList.add(param);
        }
        return this;
    }

    @Transient
    public Map getValidatorParamMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.validatorParamList.size(); ++i) {
            String key = this.validatorParamList.get(i).getName();
            String value = this.validatorParamList.get(i).getValue();
            map.put(key, value);
        }
        return map;
    }

    public String getCodeTableName() {
        return this.codeTableName;
    }

    public void setCodeTableName(String codeTableName) {
        if (codeTableName != null) {
            this.codeTableName = codeTableName.trim();
        }
        this.handleFieldCodeTableName();
    }

    public void handleFieldCodeTableName() {
        if (this.getCodeTableName() != null && this.getCodeTableName().trim().length() != 0) {
            this.setPopulatorClassName(POPULATOR_CLASS_NAME);
            HDpFieldPopulatorParameter o = new HDpFieldPopulatorParameter();
            o.setName(PARAM_NAME_FOR_CODE_TABLE);
            o.setValue(this.getCodeTableName());
            Iterator<HDpFieldPopulatorParameter> iterator = this.getPopulatorParamList().iterator();
            while (iterator.hasNext()) {
                HDpFieldPopulatorParameter param = iterator.next();
                if (!param.getName().equals(PARAM_NAME_FOR_CODE_TABLE)) continue;
                iterator.remove();
            }
            this.getPopulatorParamList().add(o);
        } else {
            this.setPopulatorClassName(null);
            Iterator<HDpFieldPopulatorParameter> iterator = this.getPopulatorParamList().iterator();
            while (iterator.hasNext()) {
                HDpFieldPopulatorParameter param = iterator.next();
                if (!param.getName().equals(PARAM_NAME_FOR_CODE_TABLE)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    @Transient
    public List<HDpFieldGeneralParameter> getGeneralParamList() {
        return this.generalParamList;
    }

    public void setGeneralParamList(List<HDpFieldGeneralParameter> generalParamList) {
        this.generalParamList = generalParamList;
    }

    public void addGeneralParam(HDpFieldGeneralParameter parameter) {
        this.generalParamList.add(parameter);
    }

    @Override
    @Transient
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        if (urlTemplate != null) {
            this.urlTemplate = urlTemplate.trim();
        }
    }

    @Override
    @Transient
    public String getFieldCode() {
        return this.fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        if (fieldCode != null) {
            this.fieldCode = fieldCode.trim();
        }
    }

    @Override
    @Transient
    public String getCodeValue() {
        return this.codeValue;
    }

    @Override
    public void setCodeValue(String codeValue) {
        this.codeValue = codeValue;
    }

    @Override
    @Transient
    public List<HDpFieldEvent> getEventsList() {
        return this.eventsList;
    }

    public void setEventsList(List<HDpFieldEvent> eventsList) {
        this.eventsList = eventsList;
    }

    public void addEvent(HDpFieldEvent event) {
        this.eventsList.add(event);
    }

    @Override
    @Transient
    public List<HDpFieldMode> getModes() {
        return this.modes;
    }

    public void setModes(List<HDpFieldMode> modes) {
        this.modes = modes;
    }

    public void addMode(HDpFieldMode mode) {
        this.modes.add(mode);
    }

    @Transient
    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    @Transient
    public String getRolesInclude() {
        return this.rolesInclude;
    }

    public void setRolesInclude(String rolesInclude) {
        this.rolesInclude = rolesInclude;
    }

    @Override
    @Transient
    public boolean isVisibleDefaultValue() {
        return this.visibleDefaultValue;
    }

    public void setVisibleDefaultValue(boolean visibleDefaultValue) {
        this.visibleDefaultValue = visibleDefaultValue;
    }

    @Override
    @Transient
    public String getVisibleFieldName() {
        return this.visibleFieldName;
    }

    public void setVisibleFieldName(String visibleFieldName) {
        this.visibleFieldName = visibleFieldName;
    }

    @Transient
    public boolean isVisiblePlaceHolder() {
        return this.visiblePlaceHolder;
    }

    public void setVisiblePlaceHolder(boolean visiblePlaceHolder) {
        this.visiblePlaceHolder = visiblePlaceHolder;
    }

    @Override
    @Transient
    public String getInitialDefaultValue() {
        return this.initialDefaultValue;
    }

    public void setInitialDefaultValue(String initialDefaultValue) {
        this.initialDefaultValue = initialDefaultValue;
    }

    @Override
    @Transient
    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    @Override
    @Transient
    public HDpFormField getAttachedField() {
        return this.attachedField;
    }

    public void setAttachedField(HDpFormField attachedField) {
        this.attachedField = attachedField;
    }

    @Transient
    public List<HDpFieldOption> getInitialOptions() {
        return this.initialOptions;
    }

    public void setInitialOptions(List<HDpFieldOption> initialOptions) {
        this.initialOptions = initialOptions;
    }

    @Transient
    public String getLabelCssClassl() {
        return this.labelCssClassl;
    }

    public void setLabelCssClassl(String labelCssClassl) {
        this.labelCssClassl = labelCssClassl;
    }

    @Override
    public Integer getDisplayedLength() {
        return this.displayedLength;
    }

    public void setDisplayedLength(Integer displayedLength) {
        this.displayedLength = displayedLength;
    }

    public static enum FormFieldDataType {
        TEXT,
        TEXT_AREA,
        DATA,
        LIST,
        RADIO,
        CHECKBOX,
        LABEL;

    }
}

