/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HFrEventKeys;
import com.exlibris.core.infra.model.HPersistent;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="SET_ERROR_EVENTS_TO_INFO", query="update HFrEvent as event set eventSeverity = :eventSeverity where event In (Select event from HFrEvent as event left join event.eventKeys as key where event.eventType = :eventType and key.name='PID' and key.value = :pid)")})
@AttributeOverride(name="id", column=@Column(name="Event_ID_Number"))
@javax.persistence.Table(name="HFREVENT")
@Table(appliesTo="HFREVENT", indexes={@Index(name="HFREVENT_ID_TYPE", columnNames={"EVENT_ID_NUMBER", "EVENT_TYPE"})})
public class HFrEvent
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private static final int VALUE_LENGTH = 4000;
    private String eventType;
    private Category eventCategory;
    private Severity eventSeverity;
    private Calendar eventDate;
    private DividedDate eventDateDummy;
    private String machineAddress;
    private String module;
    private String subModule;
    private Integer eventDuration;
    private String eventValues;
    private String eventDescription;
    private String scope;
    private String userGroup;
    private String userName;
    private String userOnCampus;
    private String eventContext;
    private String productName;
    private HashMap<String, String> eventParamValue;
    private String sessionId;
    private List<HFrEventKeys> eventKeys;
    public static Comparator<HFrEvent> typeComparator = new Comparator<HFrEvent>(){

        @Override
        public int compare(HFrEvent o1, HFrEvent o2) {
            return o1.compareTo(o2);
        }
    };

    public HFrEvent() {
        this.setEventDate(this.eventDate);
    }

    @Column(length=20, name="Event_Type", nullable=false)
    @Index(name="HFREVENT_TYPE")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Column(length=20, name="Event_Category")
    public Category getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(Category eventCategory) {
        this.eventCategory = eventCategory;
    }

    @Column(name="Event_Severity")
    @Index(name="HFREVENT_SEVERITY")
    @Enumerated
    public Severity getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(Severity eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    @Column(name="Event_Date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="HFREVENT_DATE")
    public Calendar getEventDate() {
        if (this.eventDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.eventDate;
    }

    public void setEventDate(Calendar eventDate) {
        this.eventDate = eventDate;
        this.eventDateDummy = new DividedDate(this.eventDate);
        this.eventDate = this.eventDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getEventDateDummy() {
        return this.eventDateDummy;
    }

    public void setEventDateDummy(DividedDate eventDateDummy) {
        this.eventDateDummy = eventDateDummy;
    }

    @Column(length=255, name="Machine_Address")
    public String getMachineAddress() {
        return this.machineAddress;
    }

    public void setMachineAddress(String machineAddress) {
        this.machineAddress = machineAddress;
    }

    @Column(length=255, name="module")
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Column(length=255, name="Sub_Module")
    @Index(name="HFREVENT_SUB_MODULE")
    public String getSubModule() {
        return this.subModule;
    }

    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    @Column(name="Event_Duration")
    public Integer getEventDuration() {
        return this.eventDuration;
    }

    public void setEventDuration(Integer eventDuration) {
        this.eventDuration = eventDuration;
    }

    @Column(length=4000, name="Event_Values")
    public String getEventValues() {
        return this.eventValues;
    }

    public void setEventValues(String eventValues) {
        int length = HFrEventKeys.getNullSafeLength(eventValues);
        String newString = HFrEventKeys.getLimitedLengthString(eventValues, 4000);
        this.eventValues = length < 1333 ? newString : HFrEventKeys.getLimitedUTF8LengthString(newString, 4000);
    }

    @Column(length=4000, name="Event_Description")
    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        int length = HFrEventKeys.getNullSafeLength(eventDescription);
        String newString = HFrEventKeys.getLimitedLengthString(eventDescription, 4000);
        this.eventDescription = length < 1333 ? newString : HFrEventKeys.getLimitedUTF8LengthString(newString, 4000);
    }

    @Column(length=100, name="User_Group")
    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    @Column(length=100, name="User_Name", nullable=false)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(length=20, name="Source_On_Campus")
    public String getUserOnCampus() {
        return this.userOnCampus;
    }

    public void setUserOnCampus(String sourceOnCampus) {
        this.userOnCampus = sourceOnCampus;
    }

    @Column(length=4000, name="Event_Context")
    public String getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(String eventContext) {
        int length = HFrEventKeys.getNullSafeLength(eventContext);
        String newString = HFrEventKeys.getLimitedLengthString(eventContext, 4000);
        this.eventContext = length < 1333 ? newString : HFrEventKeys.getLimitedUTF8LengthString(newString, 4000);
    }

    @Column(length=255, name="Product_Name")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Transient
    public HashMap<String, String> getEventParamValue() {
        return this.eventParamValue;
    }

    public void setEventParamValue(HashMap<String, String> eventParamValue) {
        this.eventParamValue = eventParamValue;
        String convertMapParamValueToString = "";
        Iterator<String> iter = eventParamValue.keySet().iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            String value = eventParamValue.get(param);
            convertMapParamValueToString = convertMapParamValueToString + param + "=" + value + (iter.hasNext() ? ";" : "");
        }
        this.setEventValues(convertMapParamValueToString);
    }

    @Column(length=100, name="Session_Id")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Column(length=100, name="Scope", nullable=false)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @OneToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="EVENT_ID")
    public List<HFrEventKeys> getEventKeys() {
        return this.eventKeys;
    }

    public void setEventKeys(List<HFrEventKeys> eventKeys) {
        this.eventKeys = eventKeys;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventCategory == null ? 0 : this.eventCategory.hashCode());
        result = 31 * result + (this.eventContext == null ? 0 : this.eventContext.hashCode());
        result = 31 * result + (this.eventDate == null ? 0 : this.eventDate.hashCode());
        result = 31 * result + (this.eventDescription == null ? 0 : this.eventDescription.hashCode());
        result = 31 * result + (this.eventDuration == null ? 0 : this.eventDuration.hashCode());
        result = 31 * result + (this.eventSeverity == null ? 0 : this.eventSeverity.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.eventValues == null ? 0 : this.eventValues.hashCode());
        result = 31 * result + (this.machineAddress == null ? 0 : this.machineAddress.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.productName == null ? 0 : this.productName.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + (this.subModule == null ? 0 : this.subModule.hashCode());
        result = 31 * result + (this.userGroup == null ? 0 : this.userGroup.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.userOnCampus == null ? 0 : this.userOnCampus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFrEvent other = (HFrEvent)obj;
        if (this.eventCategory == null ? other.eventCategory != null : !this.eventCategory.equals((Object)other.eventCategory)) {
            return false;
        }
        if (this.eventContext == null ? other.eventContext != null : !this.eventContext.equals(other.eventContext)) {
            return false;
        }
        if (this.eventDate == null ? other.eventDate != null : !this.eventDate.equals(other.eventDate)) {
            return false;
        }
        if (this.eventDescription == null ? other.eventDescription != null : !this.eventDescription.equals(other.eventDescription)) {
            return false;
        }
        if (this.eventDuration == null ? other.eventDuration != null : !this.eventDuration.equals(other.eventDuration)) {
            return false;
        }
        if (this.eventSeverity == null ? other.eventSeverity != null : !this.eventSeverity.equals((Object)other.eventSeverity)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        if (this.eventValues == null ? other.eventValues != null : !this.eventValues.equals(other.eventValues)) {
            return false;
        }
        if (this.machineAddress == null ? other.machineAddress != null : !this.machineAddress.equals(other.machineAddress)) {
            return false;
        }
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (this.productName == null ? other.productName != null : !this.productName.equals(other.productName)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        if (this.subModule == null ? other.subModule != null : !this.subModule.equals(other.subModule)) {
            return false;
        }
        if (this.userGroup == null ? other.userGroup != null : !this.userGroup.equals(other.userGroup)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return !(this.userOnCampus == null ? other.userOnCampus != null : !this.userOnCampus.equals(other.userOnCampus));
    }

    @Override
    public int compareTo(Object o) {
        HFrEvent event = (HFrEvent)o;
        int result = 0;
        if (this.eventType != null) {
            result = this.getEventType().compareTo(event.getEventType());
        }
        if (result == 0 && this.module != null) {
            result = this.module.compareTo(event.getModule());
        }
        if (result == 0 && this.subModule != null) {
            result = this.subModule.compareTo(event.getSubModule());
        }
        if (result == 0 && this.eventSeverity != null) {
            result = this.eventSeverity.compareTo(event.getEventSeverity());
        }
        return result;
    }

    public boolean isInList(List<HFrEvent> list) {
        for (HFrEvent event : list) {
            if (this.compareTo(event) != 0) continue;
            return true;
        }
        return false;
    }

    public static enum Category {
        APPLICATION,
        SECURITY,
        SYSTEM;

    }

    public static enum Severity {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

