/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HFrPublishingConfiguration;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.digitool.repository.replication.xmlbeans.Param;
import com.exlibris.digitool.repository.replication.xmlbeans.Params;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;

@Entity
public class HFrPublishingProfile
extends HOwneredEntity {
    public static final long INCLUDE_CMS = 4L;
    public static final long INCLUDE_AR = 8L;
    private String name;
    private String description;
    private Status status;
    private long sharedOptions;
    private String converterXParams;
    private Map<String, String> converterParams;
    private String converterPluginName;
    private String publisherPluginName;
    private String publisherXParams;
    private Map<String, String> publisherParams;
    private HFrPublishingConfiguration publishingConfiguration;
    private String profileStatus;

    public HFrPublishingProfile() {
        this.status = Status.ACTIVE;
        this.converterParams = new HashMap<String, String>();
        this.publisherParams = new HashMap<String, String>();
    }

    public HFrPublishingProfile(HFrPublishingProfile profile) {
        this.status = profile.status;
        this.name = profile.name;
        this.description = profile.description;
        this.setCreator(profile.getCreator());
        this.setModifiedBy(profile.getModifiedBy());
        this.setCreateDate(Calendar.getInstance());
        this.setModificationDate(Calendar.getInstance());
        this.publisherPluginName = profile.publisherPluginName;
        this.converterPluginName = profile.converterPluginName;
        this.setConverterXParams(profile.converterXParams);
        this.setPublisherXParams(profile.publisherXParams);
        this.publishingConfiguration = profile.publishingConfiguration;
    }

    @Column
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=4000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Enumerated(value=EnumType.STRING)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Transient
    public String getProfileStatus() {
        return this.status.toString();
    }

    public void setProfileStatus(String profileStatus) {
        this.status = Status.valueOf(profileStatus);
        this.profileStatus = profileStatus;
    }

    @Column(name="shared_options")
    public long getSharedOptions() {
        return this.sharedOptions;
    }

    public void setSharedOptions(long sharedOptions) {
        this.sharedOptions = sharedOptions;
    }

    @Transient
    public boolean isIncludeCms() {
        return (4L & this.sharedOptions) == 4L;
    }

    public void setIncludeCms(boolean includeCms) {
        this.sharedOptions = includeCms ? (this.sharedOptions |= 4L) : (this.sharedOptions &= 0xFFFFFFFFFFFFFFFBL);
    }

    @Transient
    public boolean isIncludeAr() {
        return (8L & this.sharedOptions) == 8L;
    }

    public void setIncludeAr(boolean includeAr) {
        this.sharedOptions = includeAr ? (this.sharedOptions |= 8L) : (this.sharedOptions &= 0xFFFFFFFFFFFFFFF7L);
    }

    @Column(name="converter_x_params")
    public String getConverterXParams() {
        this.converterXParams = this.getParametersFromMap(this.converterParams).toString();
        return this.converterXParams;
    }

    public void setConverterXParams(String converterXParams) {
        this.converterXParams = converterXParams;
        this.converterParams = this.getParametersByMap(converterXParams);
    }

    @Transient
    public Map<String, String> getConverterParams() {
        return this.converterParams;
    }

    public void setConverterParams(Map<String, String> converterParams) {
        this.converterParams = converterParams;
    }

    @Column(name="publisher_x_params")
    public String getPublisherXParams() {
        this.publisherXParams = this.getParametersFromMap(this.publisherParams).toString();
        return this.publisherXParams;
    }

    public void setPublisherXParams(String publisherXParams) {
        this.publisherXParams = publisherXParams;
        this.publisherParams = this.getParametersByMap(publisherXParams);
    }

    @Transient
    public Map<String, String> getPublisherParams() {
        return this.publisherParams;
    }

    public void setPublisherParams(Map<String, String> publisherParams) {
        this.publisherParams = publisherParams;
    }

    @ManyToOne(targetEntity=HFrPublishingConfiguration.class)
    public HFrPublishingConfiguration getPublishingConfiguration() {
        return this.publishingConfiguration;
    }

    public void setPublishingConfiguration(HFrPublishingConfiguration publishingConfiguration) {
        this.publishingConfiguration = publishingConfiguration;
    }

    @Transient
    private Map<String, String> getParametersByMap(String xParams) {
        if (xParams != null) {
            Params params;
            try {
                params = Params.Factory.parse(xParams);
            }
            catch (XmlException e) {
                return null;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            Param[] prms = params.getParamArray();
            for (int i = 0; i < prms.length; ++i) {
                Param param = prms[i];
                if (!StringUtils.isNotEmpty((String)param.getName()) || !StringUtils.isNotEmpty((String)param.getStringValue())) continue;
                paramsMap.put(param.getName(), param.getStringValue());
            }
            return paramsMap;
        }
        return null;
    }

    @Transient
    private Params getParametersFromMap(Map<String, String> paramsMap) {
        Params params = Params.Factory.newInstance();
        if (paramsMap != null) {
            for (Map.Entry<String, String> curEntry : paramsMap.entrySet()) {
                Param tempParam = params.addNewParam();
                tempParam.setName(curEntry.getKey());
                tempParam.setStringValue(curEntry.getValue());
            }
        }
        return params;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName();
    }

    public void setPublisherPluginName(String publisherPluginName) {
        this.publisherPluginName = publisherPluginName;
    }

    public String getPublisherPluginName() {
        return this.publisherPluginName;
    }

    public void setConverterPluginName(String converterPluginName) {
        this.converterPluginName = converterPluginName;
    }

    public String getConverterPluginName() {
        return this.converterPluginName;
    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        DELETED;

    }
}

