/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.codetables;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.codetables.HTableOfTables;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findDistinctLanguages", query="select distinct lang from HCodeTables"), @NamedQuery(name="findDistinctLanguagesByName", query="select distinct lang from HCodeTables where code_Table_Name = :codeTableName"), @NamedQuery(name="findCodesByTableIdandLanguage", query="from HCodeTables where tableOfTables = :table and lang = :language"), @NamedQuery(name="findAllCodesByNameandLanguage", query="from HCodeTables where codeTableName = :codeTableName and lang = :language and owner = :owner order by displayOrder"), @NamedQuery(name="findEnabledCodesByNameandLanguage", query="from HCodeTables where codeTableName = :codeTableName and lang = :language and owner = :owner and enabled = 1 order by displayOrder"), @NamedQuery(name="findAllCodesByTableName", query="from HCodeTables where codeTableName = :codeTableName and owner = :owner order by displayOrder,lang"), @NamedQuery(name="findCodesByNameandLanguageandCode", query="from HCodeTables where codeTableName = :codeTableName and lang = :language and code = :code and owner = :owner order by display_Order"), @NamedQuery(name="findCodeTableByLanguageAndDefaultValue", query="from HCodeTables where codeTableName = :codeTableName and lang = :language and defaultValue = true and owner = :owner order by display_Order"), @NamedQuery(name="findCodesByTableName", query="from HCodeTables where codeTableName = :codeTableName and owner = :owner and enabled = 1 order by code,displayOrder,lang"), @NamedQuery(name="findCodesByNameandCode", query="from HCodeTables where codeTableName = :codeTableName and code = :code and owner = :owner order by displayOrder"), @NamedQuery(name="findMaxDislayOrder", query="select max(displayOrder) from HCodeTables where codeTableName = :codeTableName and owner = :owner"), @NamedQuery(name="findLastUpdatedDateForCodeTable", query="select max(ct.modificationDate) from HCodeTables as ct where ct.tableOfTables.codeTableName = :tableName and owner = :owner"), @NamedQuery(name="findAllByTableName", query="from HCodeTables where codeTableName = :codeTableName order by displayOrder,lang")})
@Table(name="C_C_CODE_TABLES", uniqueConstraints={@UniqueConstraint(columnNames={"CODE_TABLE_NAME", "LANG", "CODE", "OWNER"})})
@org.hibernate.annotations.Table(appliesTo="C_C_CODE_TABLES", indexes={@Index(name="CODE_TABLE_CODE_TNAME", columnNames={"CODE", "CODE_TABLE_NAME"})})
public class HCodeTables
extends HOwneredEntity {
    public static final String ORDER_BY_DISPLAYORDER = "displayOrder";
    public static final String ORDER_BY_CODE = "code,displayOrder,lang";
    public static final String ORDER_BY_DESCRIPTION = "description";
    public static final String ORDER_BY_DEFUALT_FIRST = "defaultValue desc";
    private HTableOfTables tableOfTables;
    private String codeTableName;
    private String lang;
    private String code;
    private String description;
    private String color;
    private int displayOrder;
    private boolean defaultValue;
    private String icon;
    private boolean enabled;
    private boolean deletePermitted;
    private String note;

    public HCodeTables() {
    }

    public HCodeTables(String codeTableName, String lang, String code, String description, String owner) {
        this.codeTableName = codeTableName;
        this.lang = lang;
        this.code = code;
        this.description = description;
        this.setOwner(owner);
    }

    public HCodeTables(HTableOfTables tableOfTables, String codeTableName, String lang, String code, String description, String color, int displayOrder, boolean defaultValue, String icon, boolean enabled, String owner) {
        this.tableOfTables = tableOfTables;
        this.codeTableName = codeTableName;
        this.lang = lang;
        this.code = code;
        this.description = description;
        this.color = color;
        this.displayOrder = displayOrder;
        this.defaultValue = defaultValue;
        this.icon = icon;
        this.enabled = enabled;
        this.setOwner(owner);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TABLE_OF_TABLE_ID")
    public HTableOfTables getTableOfTables() {
        return this.tableOfTables;
    }

    public void setTableOfTables(HTableOfTables tableOfTables) {
        this.tableOfTables = tableOfTables;
    }

    @Column(name="CODE_TABLE_NAME", nullable=false, length=50)
    @Index(name="CODE_TABLES_CODE_TABLE_NAME")
    public String getCodeTableName() {
        return this.codeTableName;
    }

    public void setCodeTableName(String codeTableName) {
        this.codeTableName = codeTableName;
    }

    @Column(name="LANG", nullable=false, length=28)
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    @Column(name="CODE", nullable=false, length=255)
    @Index(name="CODE_TABLES_CODE")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="description", nullable=false, length=4000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="color", length=50)
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Column(name="DISPLAY_ORDER")
    @Index(name="CODE_TABLES_DISPLAY_ORDER")
    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Column(name="DEFAULT_VALUE")
    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Column(name="ENABLED")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Column(name="DELETE_PERMITTED", nullable=true, length=1)
    public boolean isDeletePermitted() {
        return this.deletePermitted;
    }

    public void setDeletePermitted(boolean deletePermitted) {
        this.deletePermitted = deletePermitted;
    }

    @Column(name="NOTE", nullable=true, length=4000)
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (this.codeTableName == null ? 0 : this.codeTableName.hashCode());
        hash = hash * 31 + (this.lang == null ? 0 : this.lang.hashCode());
        hash = hash * 31 + (this.code == null ? 0 : this.code.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HCodeTables)) {
            return false;
        }
        HCodeTables other = (HCodeTables)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.codeTableName == null ? other.codeTableName != null : !this.codeTableName.equals(other.codeTableName)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.defaultValue != other.defaultValue) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayOrder != other.displayOrder) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.lang == null ? other.lang != null : !this.lang.equals(other.lang));
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        HCodeTables other = (HCodeTables)o;
        int result = this.codeTableName.compareTo(other.codeTableName);
        if (result == 0 && (result = this.lang.compareTo(other.lang)) == 0) {
            result = this.code.compareTo(other.code);
        }
        return result;
    }
}

