/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.rules;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.rules.HFrRuleParam;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="HFR_RULE")
public class HFrRule
extends HOwneredEntity {
    private List<HFrRuleParam> ruleParams;
    private String ruleType;
    private boolean active;
    private int order;
    private String name;
    private String description;
    private String indexXml;
    private boolean defaultRule;

    public HFrRule() {
    }

    public HFrRule(HFrRule rule) {
        this.ruleType = rule.getRuleType();
        this.active = rule.isActive();
        this.order = rule.getOrder();
        this.name = rule.getName();
        this.description = rule.getDescription();
        this.setCreator(rule.getCreator());
        this.setModifiedBy(rule.getModifiedBy());
        this.setCreateDate(Calendar.getInstance());
        this.setModificationDate(Calendar.getInstance());
        this.setOwner(rule.getOwner());
        for (HFrRuleParam param : rule.getParams()) {
            this.addParameter(new HFrRuleParam(param));
        }
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="rule_id")
    public List<HFrRuleParam> getParams() {
        return this.ruleParams;
    }

    @Column(name="NAME", length=50)
    @Searchable
    public String getName() {
        return this.name;
    }

    @Column(name="IS_ACTIVE", nullable=false)
    public boolean isActive() {
        return this.active;
    }

    @Column(name="RULE_TYPE", nullable=false)
    public String getRuleType() {
        return this.ruleType;
    }

    @Column(name="PARAM_ORDER", nullable=false)
    public int getOrder() {
        return this.order;
    }

    @Column(name="DESCRIPTION")
    @Searchable
    public String getDescription() {
        return this.description;
    }

    @Column(name="DEFAULT_RULE")
    public boolean isDefaultRule() {
        return this.defaultRule;
    }

    @Transient
    public HFrRuleParam getRuleParamByName(String paramName) {
        if (this.ruleParams == null) {
            return null;
        }
        for (HFrRuleParam param : this.ruleParams) {
            if (!param.getName().equalsIgnoreCase(paramName)) continue;
            return param;
        }
        return null;
    }

    @Transient
    public List<HFrRuleParam> getRuleParamsBySection(String ... ruleSections) {
        ArrayList<HFrRuleParam> ret = new ArrayList<HFrRuleParam>();
        for (HFrRuleParam ruleParam : this.getParams()) {
            for (String section : ruleSections) {
                if (!ruleParam.getType().equals(section)) continue;
                ret.add(ruleParam);
            }
        }
        return ret;
    }

    public void addParameter(HFrRuleParam param) {
        if (this.getParams() == null) {
            this.setParams(new ArrayList<HFrRuleParam>());
        }
        param.setRule(this);
        this.getParams().add(param);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public void setParams(List<HFrRuleParam> params) {
        this.ruleParams = params;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultRule(boolean defaultRule) {
        this.defaultRule = defaultRule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.order;
        result = 31 * result + (this.ruleParams == null ? 0 : ((Object)this.ruleParams).hashCode());
        result = 31 * result + (this.ruleType == null ? 0 : this.ruleType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFrRule other = (HFrRule)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.ruleParams == null ? other.ruleParams != null : !((Object)this.ruleParams).equals(other.ruleParams)) {
            return false;
        }
        return !(this.ruleType == null ? other.ruleType != null : !this.ruleType.equals(other.ruleType));
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }
}

