/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.common;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.SynchronizedDateFormat;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DateHandler {
    private static SynchronizedDateFormat dateFormatter = null;
    private static SynchronizedDateFormat timeFormatter = null;
    private static SynchronizedDateFormat internalDateFormatter = null;
    private static SynchronizedDateFormat timestampDateFormatter = null;
    private static SynchronizedDateFormat smsDateFormatter = null;
    public static final String GENERAL_PARAMETERS_TABLE = "GeneralParameters";
    public static final String SYSTEM_DATE_FORMAT = "system_date_format";
    public static final String SYSTEM_TIME_FORMAT = "system_time_format";
    public static final String INTERNAL_DATE_FORMAT = "internal_date_format";
    public static final String TIME_STAMP_FORMAT = "time_stamp_date_format";
    public static final String SMS_DATE_FORMAT = "sms_date_format";
    public static String dateFormat = null;
    public static String timeFormat = null;
    public static String internalDateFormat = null;
    public static String timestampDateFormat = null;
    public static String smsDateFormat = null;
    public static String xmlDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static String xmlDateFormatWithMS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static String yearDateFormat = "yyyy";
    public static String RetentionPolicyDateStr = "dd/MM/yyyy HH:mm:SS";
    public static String RetentionPolicyXmlDateStr = "yyyy-MM-dd HH:mm:SS";
    public static SimpleDateFormat RetentionPolicyDateFormat = new SimpleDateFormat(RetentionPolicyDateStr);
    private static final ExLogger logger = ExLogger.getExLogger(DateHandler.class);

    public static void reset() {
        DateHandler.init();
    }

    private static void init() {
        if (!DateHandler.initializeFromDB()) {
            try {
                GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
                dateFormat = gpm.getParameter("repository", SYSTEM_DATE_FORMAT);
                if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(dateFormat)) {
                    dateFormat = "MM/dd/yyyy";
                }
                dateFormatter = new SynchronizedDateFormat(dateFormat);
                timeFormat = gpm.getParameter("general", SYSTEM_TIME_FORMAT);
                if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(timeFormat)) {
                    timeFormat = "hh:mm:ss z";
                }
                timeFormatter = new SynchronizedDateFormat(timeFormat);
                internalDateFormat = "yyyy-MM-dd HH:mm:ss";
                smsDateFormat = "dd-MMM HH:mm";
                smsDateFormatter = new SynchronizedDateFormat(smsDateFormat);
                internalDateFormatter = new SynchronizedDateFormat(internalDateFormat);
                timestampDateFormat = "yyyyMMdd_HHmmss";
                timestampDateFormatter = new SynchronizedDateFormat(timestampDateFormat);
            }
            catch (Throwable tr) {
                throw new ExceptionInInitializerError(tr.getMessage());
            }
        }
    }

    private static boolean initializeFromDB() {
        boolean result = false;
        CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        if (codeTableManager != null) {
            List<HMappingTables> dateMapppingTable = codeTableManager.findMappingTableByName(GENERAL_PARAMETERS_TABLE);
            for (HMappingTables mappingTables : dateMapppingTable) {
                String code = mappingTables.getTargetCode();
                if (code != null && code.equals(SYSTEM_DATE_FORMAT)) {
                    dateFormat = mappingTables.getSourceCode1();
                    dateFormatter = new SynchronizedDateFormat(dateFormat);
                }
                if (code != null && code.equals(SYSTEM_TIME_FORMAT)) {
                    timeFormat = mappingTables.getSourceCode1();
                    timeFormatter = new SynchronizedDateFormat(timeFormat);
                }
                if (code != null && code.equals(INTERNAL_DATE_FORMAT)) {
                    internalDateFormat = mappingTables.getSourceCode1();
                    internalDateFormatter = new SynchronizedDateFormat(internalDateFormat);
                }
                if (code != null && code.equals(TIME_STAMP_FORMAT)) {
                    timestampDateFormat = mappingTables.getSourceCode1();
                    timestampDateFormatter = new SynchronizedDateFormat(timestampDateFormat);
                }
                if (code == null || !code.equals(SMS_DATE_FORMAT)) continue;
                smsDateFormat = mappingTables.getSourceCode1();
                smsDateFormatter = new SynchronizedDateFormat(smsDateFormat);
            }
        }
        if (null == dateFormat) {
            logger.warn((Object)"GeneralParameters:system_date_format not found", new String[0]);
        }
        if (null == timeFormat) {
            logger.warn((Object)"GeneralParameters:system_time_format not found", new String[0]);
        }
        if (null == internalDateFormat) {
            logger.warn((Object)"GeneralParameters:internal_date_format not found", new String[0]);
        }
        if (null == timestampDateFormat) {
            logger.warn((Object)"GeneralParameters:time_stamp_date_format not found", new String[0]);
        }
        if (null == smsDateFormat) {
            logger.warn((Object)"GeneralParameters:sms_date_format not found", new String[0]);
        }
        if (dateFormat != null && timeFormat != null && internalDateFormat != null && timestampDateFormat != null && smsDateFormat != null) {
            result = true;
        }
        return result;
    }

    public static String internalToUI(String internalDate) throws ParseException {
        Date intDate = internalDateFormatter.parse(internalDate);
        return dateFormatter.format(intDate);
    }

    public static String uiToInternal(String internalDate) throws ParseException {
        Date intDate = dateFormatter.parse(internalDate);
        return internalDateFormatter.format(intDate);
    }

    public static String getDateFormat() {
        return dateFormat;
    }

    public static SimpleDateFormat getDateFormatter() {
        return dateFormatter.getDateFormatClone();
    }

    public static SimpleDateFormat getTimeFormatter() {
        return timeFormatter.getDateFormatClone();
    }

    public static String getInternelDateFormat() {
        return internalDateFormat;
    }

    public static Calendar getDate(String strDate) throws ParseException {
        Date date = new Date();
        if ((strDate = strDate.trim()).length() < 11) {
            strDate = strDate + " 00:00:00";
        }
        date = internalDateFormatter.parse(strDate);
        Calendar cal = null;
        cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date getInternalDate(String strDate) throws ParseException {
        return internalDateFormatter.parse(strDate);
    }

    public static String getDateStringFormat(String strDate) throws ParseException {
        Date date = new Date();
        String dateString = null;
        date = internalDateFormatter.parse(strDate);
        dateString = internalDateFormatter.format(date);
        return dateString;
    }

    public static String getStringFormatFromCalendar(Calendar cal) {
        if (cal == null) {
            return null;
        }
        Date d = cal.getTime();
        String dateString = internalDateFormatter.format(d);
        return dateString;
    }

    public static String getSmsDateFormat(Calendar cal) {
        if (cal == null) {
            return null;
        }
        Date d = cal.getTime();
        String dateString = smsDateFormatter.format(d);
        return dateString;
    }

    public static Date parseDateByFormat(String strDate) throws ParseException {
        return DateHandler.parseDateByFormat(strDate, true);
    }

    public static Date parseDateByFormat(String strDate, boolean lenient) throws ParseException {
        dateFormatter.setLenient(lenient);
        Date date = dateFormatter.parse(strDate);
        return date;
    }

    public static String formatDate(Date date) {
        try {
            String strd = dateFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatTime(Date date) {
        try {
            String strd = timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatDateAndTime(Date date) {
        try {
            String strd = dateFormatter.format(date) + " " + timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parseDateAndTime(String dateTime) {
        try {
            return timeFormatter.parse(dateTime);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static String formatDateAndTimeAsString(Date date) {
        String strd = "";
        if (date == null) {
            return strd;
        }
        try {
            strd = dateFormatter.format(date) + " " + timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTimestamp(Date date) {
        String strd = "";
        if (date == null) {
            return strd;
        }
        try {
            strd = timestampDateFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static java.sql.Date parseDate(String content) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        ArrayList<String> dateFormats = new ArrayList<String>();
        String dateFormatsStr = null;
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        dateFormatsStr = gpm.getParameter("search", "index_supported_date_formats");
        if (StringUtils.isNotBlank((String)dateFormatsStr)) {
            for (String format : dateFormatsStr.split(",")) {
                if (dateFormats.contains(format.trim())) continue;
                dateFormats.add(format.trim());
            }
        }
        dateFormats.add(xmlDateFormat);
        dateFormats.add(xmlDateFormatWithMS);
        dateFormats.add(yearDateFormat);
        if (dateFormat != null) {
            dateFormats.add(dateFormat);
        }
        if (internalDateFormat != null) {
            dateFormats.add(internalDateFormat);
        }
        String defaultDateFormatsStr = "yyyy-MM-dd HH:mm:ss, yyyy-MM-dd, dd/MM/yyyy";
        for (String string : defaultDateFormatsStr.split(",")) {
            if (dateFormats.contains(string.trim())) continue;
            dateFormats.add(string.trim());
        }
        Date date = null;
        for (String formatStr : dateFormats) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr, new Locale(SessionUtils.getSessionLanguage()));
            try {
                date = simpleDateFormat.parse(content);
                return new java.sql.Date(date.getTime());
            }
            catch (ParseException e) {
            }
        }
        return null;
    }

    static {
        DateHandler.init();
    }
}

