/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.locator;

import com.exlibris.core.infra.common.annotations.ServiceContext;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.commons.lang.StringUtils;

public class WebServiceLocator {
    private static ExLogger log = ExLogger.getExLogger(WebServiceLocator.class);
    public static final String EXLIBRIS_WS_TNS = "http://dps.exlibris.com/";
    public static final String EXLIBRIS_WS_CONTEXT = "/dpsws";
    public static final String EXLIBRIS_WS_CONTEXT_DEPOSIT = "/dpsws/deposit";
    public static final String EXLIBRIS_WS_CONTEXT_REPOSITORY = "/dpsws/repository";
    public static final String EXLIBRIS_WS_CONTEXT_BACKOFFICE = "/dpsws/backoffice";
    public static final String EXLIBRIS_WS_CONTEXT_PERMANENT = "/dpsws/permanent";
    public static final String EXLIBRIS_WS_CONTEXT_DELIVERY = "/dpsws/delivery";
    public static final String EXLIBRIS_WS_CONTEXT_INFRA = "/dpsws/infra";
    private final String WS_RECEIVE_TIMEOUT = "ws_receive_timeout_seconds";
    private final String ONE_HUNDRED_HOURS = "360000000";
    private static WebServiceLocator ourInstance = new WebServiceLocator();
    private static final String RESOURCE_BUNDLE = "global.properties";
    private static Long lock = new Long(1L);
    Map<String, String> annotation2globalPropertiesLB = new HashMap(){
        {
            this.put("deposit", "load.balancer.dep");
            this.put("repository", "load.balancer.rep");
            this.put("backoffice", "load.balancer.rep");
            this.put("permanent", "load.balancer.per");
            this.put("delivery", "load.balancer.del");
        }
    };
    Map<String, String> annotation2globalPropertiesProtocols = new HashMap(){
        {
            this.put("deposit", "protocol.dep");
            this.put("repository", "protocol.rep");
            this.put("backoffice", "protocol.rep");
            this.put("permanent", "protocol.per");
            this.put("delivery", "protocol.del");
        }
    };
    private Map<String, Service> proxyCache;
    private static MBeanServer currentServer;
    private String currentHostAddress;
    GlobalProperties globalProperties = null;

    public static WebServiceLocator getInstance() {
        return ourInstance;
    }

    private WebServiceLocator() {
        this.init();
    }

    private void init() {
        this.proxyCache = new HashMap<String, Service>();
    }

    public <T> T lookUp(Class<T> serviceEndpointInterface) {
        return this.lookUp(serviceEndpointInterface, null, null);
    }

    public <T> T lookUp(Class<T> serviceEndpointInterface, String wsdlUrlStr) {
        return this.lookUp(serviceEndpointInterface, wsdlUrlStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lookUp(Class<T> serviceEndpointInterface, String wsdlUrlStr, String contextName) {
        String serviceEndpointInterfaceName = serviceEndpointInterface.getSimpleName();
        Object ret = null;
        URL wsdlUrl = null;
        if (contextName == null) {
            ServiceContext sc = serviceEndpointInterface.getPackage().getAnnotation(ServiceContext.class);
            contextName = sc.name();
        }
        if (wsdlUrlStr == null) {
            if (this.globalProperties == null) {
                this.globalProperties = GlobalProperties.getInstance();
            }
            if (contextName != null) {
                wsdlUrlStr = this.getWsdlUrl(contextName, serviceEndpointInterfaceName);
            }
        }
        if (wsdlUrlStr != null) {
            try {
                wsdlUrl = new URL(wsdlUrlStr);
            }
            catch (MalformedURLException e) {
                log.error("Fail to build WSDL URL from " + wsdlUrlStr + " web service lookup of " + serviceEndpointInterfaceName + " will fail", new String[0]);
                e.printStackTrace();
            }
        } else {
            log.error("wsdl url string is null , web service lookup of " + serviceEndpointInterfaceName + " will fail", new String[0]);
        }
        if (wsdlUrl != null) {
            Service service;
            Boolean useWsCache = true;
            try {
                String useWsCacheStr = this.globalProperties.getProperty("use_ws_cache");
                useWsCache = Boolean.valueOf(useWsCacheStr);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to get use_ws_cache global property", new String[0]);
            }
            QName portName = new QName(EXLIBRIS_WS_TNS, serviceEndpointInterfaceName + "Port");
            if (useWsCache.booleanValue()) {
                if (this.proxyCache.containsKey(wsdlUrlStr)) {
                    service = this.proxyCache.get(wsdlUrlStr);
                } else {
                    Long l = lock;
                    synchronized (l) {
                        if (this.proxyCache.containsKey(wsdlUrlStr)) {
                            service = this.proxyCache.get(wsdlUrlStr);
                        } else {
                            QName serviceName = new QName(EXLIBRIS_WS_TNS, serviceEndpointInterfaceName);
                            service = Service.create((URL)wsdlUrl, (QName)serviceName);
                            ret = service.getPort(portName, serviceEndpointInterface);
                            this.proxyCache.put(wsdlUrlStr, service);
                        }
                    }
                }
            } else {
                QName serviceName = new QName(EXLIBRIS_WS_TNS, serviceEndpointInterfaceName);
                service = Service.create((URL)wsdlUrl, (QName)serviceName);
            }
            if (ret == null) {
                ret = service.getPort(portName, serviceEndpointInterface);
            }
        }
        String receiveTimeout = "360000000";
        try {
            receiveTimeout = this.getReceiveTimoutParameter();
        }
        catch (Exception e) {
            log.warn((Object)"failed to retrieve general parameter: 'ws_receive_timout_seconds' from general parameter. Using default timout value of 100 hours.", new String[0]);
        }
        try {
            ((BindingProvider)ret).getRequestContext().put("javax.xml.ws.client.connectionTimeout", "60000");
            ((BindingProvider)ret).getRequestContext().put("javax.xml.ws.client.receiveTimeout", receiveTimeout);
        }
        catch (Exception e) {
            log.warn((Object)"failed to set web service port timeout. Using jboss default timout value of infinity", e, new String[0]);
        }
        return (T)ret;
    }

    private String getReceiveTimoutParameter() {
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String seconds = generalParameterManager.getParameter("general", "ws_receive_timeout_seconds");
        Integer timeout = Integer.valueOf(seconds);
        timeout = timeout * 1000;
        return timeout.toString();
    }

    private String getWsdlUrl(String sc, String className) {
        String wsdlUrlStr = null;
        String lb = null;
        String lbProperty = "";
        String protocol = null;
        String protocolProperty = "";
        if (sc != null) {
            lbProperty = this.annotation2globalPropertiesLB.get(sc);
            if (lbProperty != null) {
                lb = this.globalProperties.getProperty(lbProperty);
            }
        } else {
            log.error("package annotaion is null , web service lookup of " + className + " will fail", new String[0]);
        }
        if (sc != null) {
            protocolProperty = this.annotation2globalPropertiesProtocols.get(sc);
            if (protocolProperty != null && StringUtils.isBlank((String)(protocol = this.globalProperties.getProperty(protocolProperty)))) {
                protocol = "http";
            }
        } else {
            log.error("package annotaion is null , web service lookup of " + className + " will fail", new String[0]);
        }
        if (lb != null && protocol != null) {
            wsdlUrlStr = protocol + "://" + lb + EXLIBRIS_WS_CONTEXT + "/" + sc + "/" + className + "?wsdl";
        } else {
            log.error("Fail to retrieve " + lbProperty + " or " + protocolProperty + " from global.properties , web service lookup of " + className + " will fail", new String[0]);
        }
        return wsdlUrlStr;
    }
}

