/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.queue;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.resourcemanager.SipProcessingWorkMessage;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import com.exlibris.core.infra.svc.api.queue.WorkQueueApplicationException;
import com.exlibris.core.infra.svc.api.queue.WorkQueueFactory;

public class EnqueueHelper {
    private static final ExLogger log = ExLogger.getExLogger(EnqueueHelper.class, "DEP");

    public static void enqueueSipProcessingMessage(Long sipId, Long processId, String transitionName, String nodeName, int priority) {
        try {
            SipProcessingWorkMessage message = new SipProcessingWorkMessage();
            WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(SipProcessingWorkMessage.class);
            WorkQueue workQueue = workQueueFactory.getWorkQueue("SIP_PROCESSING_QUEUE");
            message.setSipId(sipId);
            message.setTransitionName(transitionName);
            message.setProcessInstanceId(processId);
            message.setNodeName(nodeName);
            workQueue.enqueue(message, "sipID", sipId.toString(), priority, QueueConstants.messageType.QUEUE);
        }
        catch (WorkQueueApplicationException e) {
            log.error("Failed to enqueue sip to sipProcessingWorkQueue", e, sipId.toString());
        }
    }
}

