/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.resourcemanagement;

import com.exlibris.core.infra.svc.api.schema.DBSchemaUtil;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;

public class MyQueueReceiver {
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private QueueReceiver queueReceiver;

    public MyQueueReceiver(QueueConnection queueConnection, String queueName, String messageSelector) throws Exception {
        this.queueConnection = queueConnection;
        this.queueSession = queueConnection.createQueueSession(true, 1);
        if (!queueName.startsWith(DBSchemaUtil.SHR_SCHEMA + ".")) {
            queueName = DBSchemaUtil.SHR_SCHEMA + "." + queueName;
        }
        Queue queue = this.queueSession.createQueue(queueName);
        this.queueReceiver = this.queueSession.createReceiver(queue, messageSelector);
        queueConnection.start();
    }

    public void close() {
        if (this.queueReceiver != null) {
            try {
                this.queueReceiver.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.queueSession != null) {
            try {
                this.queueSession.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.queueConnection != null) {
            try {
                this.queueConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Message receive(long waitTime) throws Exception {
        return this.queueReceiver.receive(waitTime);
    }
}

