/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecAbstract;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecLocal;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecStrategy;
import com.exlibris.core.infra.svc.api.scriptRunner.GridExecExternalProcess;
import java.util.List;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridFactory;
import org.gridgain.grid.GridTaskFuture;
import org.gridgain.grid.GridTaskTimeoutException;

public class ExecGridgain
extends ExecAbstract
implements ExecStrategy {
    @Override
    public int execExternalProcess(String cmd, List<String> args) {
        ExecLocal input = new ExecLocal();
        ExecLocal result = null;
        this.cmd = cmd;
        this.args = args;
        input.setCmd(cmd);
        input.setArgs(args);
        try {
            Grid grid = GridFactory.getGrid((String)GlobalProperties.getInstance().getProperty("gridgain.cluster.name"));
            GridTaskFuture future = grid.execute(GridExecExternalProcess.class, (Object)input);
            int gridGainWaitTimeInMinutes = 30;
            GeneralParameterManager genParamMng = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            try {
                String parm = genParamMng.getParameter("background_jobs", "gridgain_wait_minutes");
                gridGainWaitTimeInMinutes = Integer.valueOf(parm);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                result = (ExecLocal)future.get((long)(gridGainWaitTimeInMinutes * 60 * 1000));
            }
            catch (GridTaskTimeoutException ex) {
                throw new RuntimeException("GridGain process timeout reached");
            }
            this.inputStream = result.getInputStream();
            this.errorStream = result.getErrorStream();
            this.exitValue = result.getExitValue();
        }
        catch (Exception e) {
            this.exitValue = 1;
            this.errorStream = e.getMessage();
        }
        return this.getExitValue();
    }
}

