/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.common.streams.EncodingUtil;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.PDSManager;
import com.exlibris.core.infra.svc.api.config.PrivilegeCacheManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import com.exlibris.core.infra.svc.api.security.SecurityHash;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.Util;

public class JaasSecurityModule
extends AbstractServerLoginModule {
    private static final ExLogger logger = ExLogger.getExLogger(JaasSecurityModule.class);
    private Principal identity;
    private char[] credential;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private String DPSUserName = null;
    private String pdsHandle = null;
    private String DPSUserInstitution = null;
    private boolean ignorePasswordCase;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get("hashCharset");
        }
        String flag = (String)options.get("ignorePasswordCase");
        this.ignorePasswordCase = Boolean.valueOf(flag);
    }

    public boolean logout() throws LoginException {
        return super.logout();
    }

    public boolean abort() throws LoginException {
        return super.abort();
    }

    public boolean commit() throws LoginException {
        try {
            return super.commit();
        }
        catch (Throwable t) {
            t.getMessage();
            t.printStackTrace();
            throw new LoginException(t.getMessage());
        }
    }

    public boolean login() throws LoginException {
        boolean authenticated;
        block17: {
            if (super.login()) {
                Object username = this.sharedState.get("javax.security.auth.login.name");
                if (username instanceof Principal) {
                    this.identity = (Principal)username;
                } else {
                    String name = username.toString();
                    try {
                        this.identity = this.createIdentity(name);
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                        throw new LoginException("Failed to create principal: " + e.getMessage());
                    }
                }
                Object password = this.sharedState.get("javax.security.auth.login.password");
                if (password instanceof char[]) {
                    this.credential = (char[])password;
                } else if (password != null) {
                    String tmp = password.toString();
                    this.credential = tmp.toCharArray();
                }
                return true;
            }
            this.loginOk = false;
            authenticated = false;
            String[] info = this.getUsernameAndPassword();
            String username = info[0];
            String password = info[1];
            try {
                Callback[] calls = new Callback[]{new NameCallback("name"), new PasswordCallback("Password", false)};
                this.callbackHandler.handle(calls);
                this.pdsHandle = ((NameCallback)calls[0]).getName();
                PdsConnector pdsConn = PdsConnector.getInstance();
                PdsUserInfo userDetails = pdsConn.getUserInfo(this.pdsHandle);
                if (((PasswordCallback)calls[1]).getPassword() != null && !String.valueOf(((PasswordCallback)calls[1]).getPassword()).equals("null") && !String.valueOf(((PasswordCallback)calls[1]).getPassword()).trim().equals("")) {
                    this.DPSUserName = userDetails.getUserName();
                    this.DPSUserInstitution = String.valueOf(((PasswordCallback)calls[1]).getPassword());
                    authenticated = true;
                    this.loginOk = true;
                    this.getUsernameAndPassword();
                    try {
                        this.identity = this.createIdentity(this.DPSUserName);
                        ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
                        ((UserPrincipal)this.identity).setPdsHandle(((NameCallback)calls[0]).getName());
                        ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                        logger.debug((Object)e.getStackTrace(), new String[0]);
                        throw new LoginException("Failed to create principal: " + e.getMessage());
                    }
                    return authenticated;
                }
                if (userDetails == null || userDetails.getUserName() == null) break block17;
                this.DPSUserName = new String(userDetails.getUserName().getBytes("ISO-8859-1"), "UTF-8");
                this.DPSUserInstitution = userDetails.getBorDeptM();
                authenticated = true;
                this.loginOk = true;
                this.getUsernameAndPassword();
                try {
                    this.identity = this.createIdentity(this.DPSUserName);
                    ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
                    ((UserPrincipal)this.identity).setPdsHandle(((NameCallback)calls[0]).getName());
                    try {
                        ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
                        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
                        HFrInstitution institution = consMng.findInstitutionByCode(this.DPSUserInstitution);
                        ((UserPrincipal)this.identity).setInstitutionPath(institution.getPath());
                        PDSManager pdsManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
                        HFrUser userByName = pdsManager.getUserByName(this.DPSUserName);
                        ((UserPrincipal)this.identity).setUserDetails(userByName);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Couldn't add extra info to the UserPrincipal", e, new String[0]);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                    logger.debug((Object)e.getStackTrace(), new String[0]);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
                return authenticated;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return authenticated;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = EncodingUtil.encodeISO88591UsingUTF8(nc.getName());
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = EncodingUtil.encodeISO88591UsingUTF8(new String(this.credential));
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        SecurityHash.getInstance().add(username, password);
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected Principal createIdentity(String username) throws Exception {
        return super.createIdentity(username);
    }

    protected String createPasswordHash(String username, String password) {
        String passwordHash = Util.createPasswordHash((String)this.hashAlgorithm, (String)this.hashEncoding, (String)this.hashCharset, (String)username, (String)password);
        return passwordHash;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }

    protected String getUsersPassword() throws LoginException {
        return "jaas";
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup gr1 = new SimpleGroup("Roles");
        HashMap<String, SimpleGroup> setsMap = new HashMap<String, SimpleGroup>();
        UserPrincipal userPrincipal = new UserPrincipal("userInfo");
        userPrincipal.setUserName(this.DPSUserName);
        String psdhandle = ((UserPrincipal)this.identity).getPdsHandle();
        userPrincipal.setPdsHandle(psdhandle);
        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        HFrInstitution institution = consMng.findInstitutionByCode(this.DPSUserInstitution);
        if (institution == null) {
            logger.warn((Object)("No institution found for code " + this.DPSUserInstitution), new String[0]);
            userPrincipal.setInstitutionCode(this.DPSUserInstitution);
            userPrincipal.setInstitutionPath(this.DPSUserInstitution);
        } else {
            userPrincipal.setInstitutionCode(institution.getCode());
            userPrincipal.setInstitutionPath(institution.getPath());
        }
        HFrUser userDetails = null;
        try {
            PDSManager pdsManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
            userDetails = pdsManager.getUserByName(this.DPSUserName);
            List<HFrUserRoles> userRoles = pdsManager.getUserRoleByUserAndInstitution(userDetails, userPrincipal.getInstitutionPath());
            userPrincipal.setUserDetails(userDetails);
            for (HFrUserRoles role : userRoles) {
                if (!role.getStatus().equals((Object)HFrUserRoles.Status.ACTIVE)) continue;
                String userRoleName = Integer.toString(role.getRoleType());
                ArrayList<String> privileges = PrivilegeCacheManager.getInstance().getPrivileges2Role(userRoleName);
                for (String privilege : privileges) {
                    gr1.addMember((Principal)new SimplePrincipal(privilege));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gr1.addMember((Principal)new SimplePrincipal("DEFAULT_ROLE"));
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        callerPrincipal.addMember((Principal)userPrincipal);
        setsMap.put("CallerPrincipal", callerPrincipal);
        setsMap.put("Roles", gr1);
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }
}

