/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.streams.EncodingUtil;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.Util;

public class JaasUserSecurityModule
extends AbstractServerLoginModule {
    private static final ExLogger logger = ExLogger.getExLogger(JaasUserSecurityModule.class);
    private Principal identity;
    private char[] credential;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private boolean ignorePasswordCase;
    private boolean isStaff;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get("hashCharset");
        }
        String flag = (String)options.get("ignorePasswordCase");
        this.ignorePasswordCase = Boolean.valueOf(flag);
    }

    public boolean logout() throws LoginException {
        return super.logout();
    }

    public boolean abort() throws LoginException {
        return super.abort();
    }

    public boolean commit() throws LoginException {
        try {
            return super.commit();
        }
        catch (Throwable t) {
            t.getMessage();
            t.printStackTrace();
            throw new LoginException(t.getMessage());
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username == null || username.toString().length() == 0) {
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            logger.debug((Object)("Authenticating as unauthenticatedIdentity=" + this.identity), new String[0]);
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(username);
            }
            catch (Exception e) {
                logger.error("Failed to create principal" + e.getMessage(), new String[0]);
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            if (this.hashAlgorithm != null) {
                password = this.createPasswordHash(username, password);
            }
            PdsConnector pdsConn = PdsConnector.getInstance();
            boolean authenticated = false;
            try {
                GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
                String institute = gpm.getParameter("pds", "calling_system");
                String fullPdsUrl = pdsConn.concatFullPdsUrl("authenticate", false, null, null, null, password, institute, username);
                String xmlContents = pdsConn.getUrlContents(fullPdsUrl);
                String parsedId = pdsConn.parseId(xmlContents);
                parsedId = URLEncoder.encode(parsedId, "UTF-8");
                if (parsedId != null && parsedId.equals(username) || xmlContents != null && xmlContents.indexOf("<auth>Y</auth>") > 0) {
                    fullPdsUrl = pdsConn.concatFullPdsUrl("login-url", false, null, null, null, password, null, username);
                    pdsConn.getUrlContents(fullPdsUrl);
                    authenticated = true;
                }
            }
            catch (Exception e) {
                logger.error(DescriptorConstants.LY_UnableToLogIn, (Object)username, (Object)e.getMessage());
                throw new FailedLoginException("unable to log into system pds, ejb exception: " + e.getMessage());
            }
            if (!authenticated) {
                logger.error(DescriptorConstants.LY_UnableToLogIn, (Object)username);
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        logger.info("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk);
        return true;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = EncodingUtil.encodeISO88591UsingUTF8(nc.getName());
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = EncodingUtil.encodeISO88591UsingUTF8(new String(this.credential));
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected String createPasswordHash(String username, String password) {
        String passwordHash = Util.createPasswordHash((String)this.hashAlgorithm, (String)this.hashEncoding, (String)this.hashCharset, (String)username, (String)password);
        return passwordHash;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }

    protected String getUsersPassword() throws LoginException {
        Object cred = this.getCredentials();
        if (cred != null) {
            return cred.toString();
        }
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] gr = new Group[1];
        SimpleGroup gr1 = new SimpleGroup("Roles");
        if (!this.isStaff) {
            gr1.addMember((Principal)new SimplePrincipal("authenticated_user"));
        } else {
            gr1.addMember((Principal)new SimplePrincipal("authenticated_staff"));
        }
        HashSet<SimpleGroup> aa = new HashSet<SimpleGroup>();
        aa.add(gr1);
        gr[0] = this.createGroup("Roles", aa);
        return gr;
    }
}

