/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;

public class SilentLogin {
    private static final String SILENT_USERS_PROPERTIES = "props/silent-users.properties";
    private static final ExLogger log = ExLogger.getExLogger(SilentLogin.class, "RPS");
    private static Properties silentUsersFile = null;
    private Context m_ctx;

    public SilentLogin() throws URISyntaxException, IOException {
        this.init(SilentLogin.getSilentUsername(), SilentLogin.getSilentPassword());
    }

    public SilentLogin(String pdsHandle) {
        this.init(pdsHandle, null);
    }

    private void init(String username, String password) {
        try {
            Properties env = new Properties();
            env.setProperty("java.naming.security.principal", username);
            if (password != null) {
                env.setProperty("java.naming.security.credentials", password);
            }
            env.setProperty("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
            env.setProperty("java.naming.authoritative", "true");
            this.m_ctx = new InitialContext(env);
        }
        catch (Exception ex) {
            log.error("Failed to create SilentLogin service locator", ex, new String[0]);
        }
    }

    public Object lookUp(String jndiBinding) {
        try {
            Object res = this.m_ctx.lookup(jndiBinding);
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static synchronized Properties getSilentUsersFile() throws URISyntaxException, IOException {
        if (silentUsersFile == null) {
            silentUsersFile = SilentLogin.loadProperties(SILENT_USERS_PROPERTIES);
        }
        return silentUsersFile;
    }

    private static String getSilentPassword() throws URISyntaxException, IOException {
        return SilentLogin.getSilentUsersFile().getProperty(SilentLogin.getSilentUsername());
    }

    private static String getSilentUsername() {
        return "slnt";
    }

    private static Properties loadProperties(String propFileName) throws URISyntaxException, IOException {
        Properties props = new Properties();
        String path = System.getProperty("jboss.server.config.url") + propFileName;
        URL url = new URL(path);
        if (new File(url.toURI()).exists()) {
            props.load(url.openStream());
            log.info("loaded application properties from file: " + path);
        } else {
            props.load(SilentLogin.class.getResourceAsStream("/" + propFileName));
            log.info("loaded application properties: /" + propFileName);
        }
        return props;
    }
}

