/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.model.HDpFieldGeneralParameter;
import com.exlibris.core.infra.model.HDpFieldMode;
import com.exlibris.core.infra.model.HDpFieldOption;
import com.exlibris.core.infra.model.HDpFieldPopulatorParameter;
import com.exlibris.core.infra.model.HDpFormField;
import com.exlibris.core.web.listgenerator.xmlbeans.XComboField;
import com.exlibris.core.web.listgenerator.xmlbeans.XLinkField;
import com.exlibris.digitool.common.forms.xmlbeans.XField;
import com.exlibris.digitool.common.forms.xmlbeans.XFieldModeType;
import com.exlibris.digitool.common.forms.xmlbeans.XFieldModes;
import com.exlibris.digitool.common.forms.xmlbeans.XGeneralParameters;
import com.exlibris.digitool.common.forms.xmlbeans.XOptions;
import com.exlibris.digitool.common.forms.xmlbeans.XPopulatorParameters;
import com.exlibris.digitool.common.forms.xmlbeans.XViewModeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FormBuilderUtilitiesApi {
    public static final int XFIELD = 1;
    public static final int XCOMBOFIELD = 2;
    public static final int XLINKFIELD = 3;
    protected static final int INTERNAL_USE = 17;
    protected static final int LINK = 8;
    private static final String WIDTH = "width";
    private static final String WIDTH_AUTO = "widthAuto";

    public static HDpFormField initHDpFormField(Object object, int fieldType) {
        HDpFormField hDpFormField = null;
        if (object != null) {
            switch (fieldType) {
                case 1: {
                    hDpFormField = FormBuilderUtilitiesApi.initHDpFormField((XField)object);
                    break;
                }
                case 2: {
                    hDpFormField = FormBuilderUtilitiesApi.initHDpFormField((XComboField)object);
                    break;
                }
                case 3: {
                    hDpFormField = FormBuilderUtilitiesApi.initHDpFormField((XLinkField)object);
                }
            }
        }
        return hDpFormField;
    }

    private static HDpFormField initHDpFormField(XField field) {
        HDpFormField hDpFormField = new HDpFormField();
        Object hdpFieldGeneralParameter = null;
        hDpFormField.setFieldName(field.getFieldName());
        hDpFormField.setFieldCode(field.getFieldCode());
        hDpFormField.setCodeValue(field.getCodeValue());
        hDpFormField.setUiToolTip(field.getUiToolTip());
        hDpFormField.setLogicType(field.getXLogicType().intValue());
        hDpFormField.setLabelCssClassl(field.getLabelCssClass());
        if (field.getDisplayedLength() != null) {
            hDpFormField.setDisplayedLength(field.getDisplayedLength().intValue());
        }
        hDpFormField.setInitialDefaultValue(field.getDefaultValue());
        hDpFormField.setFieldValue(field.getXFieldValue());
        hDpFormField.setDefaultValue(field.getDefaultValue());
        hDpFormField.setPopulatorClassName(field.getPopulatorClassName());
        int uiType = field.getXUiType().intValue();
        if (uiType == 17) {
            hDpFormField.setInternal(true);
        }
        hDpFormField.setUiType(uiType);
        hDpFormField.setUrlTemplate(field.getUrlTemplate());
        hDpFormField.setOptions(FormBuilderUtilitiesApi.getOptionsFields(field.getXOptions()));
        hDpFormField.setInitialOptions(FormBuilderUtilitiesApi.getOptionsFields(field.getXOptions()));
        if (field.getXFieldModes() != null) {
            hDpFormField.setModes(FormBuilderUtilitiesApi.getFieldModes(field.getXFieldModes()));
        }
        hDpFormField.setLabel(field.getLabel());
        hDpFormField.setRolesInclude(field.getRoles());
        hDpFormField.setCssClass(field.getCssClass());
        if (field.getVisible() != null) {
            hDpFormField.setVisibleDefaultValue(field.getVisible().getDefaultValue());
            hDpFormField.setVisibleFieldName(field.getVisible().getXFieldName());
        }
        if (field.getAttachedField() != null) {
            hDpFormField.setAttachedField(FormBuilderUtilitiesApi.initHDpFormField(field.getAttachedField()));
        }
        FormBuilderUtilitiesApi.addPopulatorParameters(field.getXPopulatorParameters(), hDpFormField);
        FormBuilderUtilitiesApi.addGeneralParameters(field.getXGeneralParameters(), hDpFormField);
        return hDpFormField;
    }

    public static void addPopulatorParameters(XPopulatorParameters xPopulatorParameters, HDpFormField hDpFormField) {
        if (xPopulatorParameters != null && xPopulatorParameters.getXPopulatorParameterArray() != null) {
            XPopulatorParameters.XPopulatorParameter[] params = xPopulatorParameters.getXPopulatorParameterArray();
            HDpFieldPopulatorParameter param = null;
            for (int i = 0; i < params.length; ++i) {
                param = new HDpFieldPopulatorParameter();
                param.setName(params[i].getParameter() == null ? null : params[i].getParameter().trim());
                param.setValue(params[i].getValue() == null ? null : params[i].getValue().trim());
                hDpFormField.addPopulatorParameter(param);
            }
        }
    }

    public static void addGeneralParameters(XGeneralParameters xGeneralParameters, HDpFormField hDpFormField) {
        XGeneralParameters.XGeneralParameter[] xGeneralParameterArray;
        if (xGeneralParameters != null && (xGeneralParameterArray = xGeneralParameters.getXGeneralParameterArray()) != null && xGeneralParameterArray.length > 0) {
            for (int i = 0; i < xGeneralParameterArray.length; ++i) {
                HDpFieldGeneralParameter hdpFieldGeneralParameter = new HDpFieldGeneralParameter();
                hdpFieldGeneralParameter.setParameter(xGeneralParameterArray[i].getParameter());
                hdpFieldGeneralParameter.setValue(xGeneralParameterArray[i].getValue());
                hDpFormField.addGeneralParam(hdpFieldGeneralParameter);
            }
        }
    }

    private static HDpFormField initHDpFormField(XComboField field) {
        HDpFormField hDpFormField = new HDpFormField();
        hDpFormField.setUiType(2);
        hDpFormField.setPopulatorClassName(field.getPopulatorClassName());
        FormBuilderUtilitiesApi.addPopulatorParameters(field.getXPopulatorParameters(), hDpFormField);
        hDpFormField.setLabel(field.getLabel());
        hDpFormField.setRolesInclude(field.getRoles());
        hDpFormField.setCssClass(field.getCssClass());
        if (field.getVisible() != null) {
            hDpFormField.setVisibleDefaultValue(field.getVisible().getDefaultValue());
            hDpFormField.setVisibleFieldName(field.getVisible().getXFieldName());
        }
        return hDpFormField;
    }

    private static HDpFormField initHDpFormField(XLinkField fieldData) {
        XGeneralParameters.XGeneralParameter[] xGeneralParameterArray;
        XGeneralParameters xGeneralParameters;
        XLinkField field = fieldData;
        HDpFormField hDpFormField = new HDpFormField();
        hDpFormField.setUrlTemplate(field.getUrlTemplate());
        hDpFormField.setUiType(8);
        if (fieldData.getXFieldModes() != null) {
            hDpFormField.setModes(FormBuilderUtilitiesApi.getFieldModes(fieldData.getXFieldModes()));
        }
        hDpFormField.setLabel(field.getLabel());
        hDpFormField.setRolesInclude(field.getRoles());
        hDpFormField.setCssClass(field.getCssClass());
        if (field.getAttachedField() != null) {
            hDpFormField.setAttachedField(FormBuilderUtilitiesApi.initHDpFormField(field.getAttachedField()));
        }
        if ((xGeneralParameters = field.getXGeneralParameters()) != null && (xGeneralParameterArray = xGeneralParameters.getXGeneralParameterArray()) != null && xGeneralParameterArray.length > 0) {
            for (int i = 0; i < xGeneralParameterArray.length; ++i) {
                HDpFieldGeneralParameter hdpFieldGeneralParameter = new HDpFieldGeneralParameter();
                hdpFieldGeneralParameter.setParameter(xGeneralParameterArray[i].getParameter());
                hdpFieldGeneralParameter.setValue(xGeneralParameterArray[i].getValue());
                hDpFormField.addGeneralParam(hdpFieldGeneralParameter);
            }
        }
        if (field.getVisible() != null) {
            hDpFormField.setVisibleDefaultValue(field.getVisible().getDefaultValue());
            hDpFormField.setVisibleFieldName(field.getVisible().getXFieldName());
            if (field.getVisible().isSetHoldPlace()) {
                hDpFormField.setVisiblePlaceHolder(field.getVisible().getHoldPlace());
            }
        }
        return hDpFormField;
    }

    public static List<HDpFieldOption> getOptionsFields(XOptions xOptions) {
        XOptions.XOption[] xOptionArray;
        ArrayList<HDpFieldOption> options = new ArrayList<HDpFieldOption>();
        if (xOptions != null && (xOptionArray = xOptions.getXOptionArray()) != null) {
            for (int j = 0; j < xOptionArray.length; ++j) {
                HDpFieldOption hFieldOption = new HDpFieldOption();
                hFieldOption.setLabel(xOptionArray[j].getLabel());
                hFieldOption.setValue(xOptionArray[j].getValue());
                options.add(hFieldOption);
            }
        }
        return options;
    }

    public static List<HDpFieldMode> getFieldModes(XFieldModes xFieldModes) {
        XFieldModes.XFieldMode[] modesList;
        ArrayList<HDpFieldMode> modes = null;
        if (xFieldModes != null && xFieldModes.getXFieldModeArray() != null && (modesList = xFieldModes.getXFieldModeArray()) != null) {
            modes = new ArrayList<HDpFieldMode>(modesList.length);
            for (XFieldModes.XFieldMode fieldMode : modesList) {
                HDpFieldMode mode = new HDpFieldMode();
                mode.setValue(fieldMode.getValue().toString());
                mode.setViewMode(fieldMode.getViewMode().toString());
                modes.add(mode);
            }
        }
        return modes;
    }

    public static int getModeByFieldModesAndPageMode(List<HDpFieldMode> modes, String mode) {
        HashMap<String, Integer> modeToOperation = new HashMap<String, Integer>(3);
        modeToOperation.put(XViewModeType.EDIT.toString(), 1);
        modeToOperation.put(XViewModeType.NEW.toString(), 1);
        modeToOperation.put(XViewModeType.VIEW.toString(), 2);
        modeToOperation.put(XViewModeType.EXTERNAL.toString(), 1);
        if (modes != null) {
            for (HDpFieldMode fieldMode : modes) {
                modeToOperation.put(fieldMode.getViewMode(), XFieldModeType.Enum.forString(fieldMode.getValue()).intValue());
            }
        }
        return (Integer)modeToOperation.get(mode.trim());
    }

    public static String addCssClass(String str, String cssClass) {
        String result = str;
        if (cssClass != null) {
            int suffixIndex = 0;
            if (str.contains(WIDTH)) {
                if (str.contains(WIDTH_AUTO)) {
                    suffixIndex = result.indexOf(WIDTH_AUTO) + WIDTH_AUTO.length();
                } else {
                    for (suffixIndex = result.indexOf(WIDTH) + WIDTH.length(); suffixIndex < result.length() && Character.digit(result.charAt(suffixIndex), 10) > -1; ++suffixIndex) {
                    }
                }
            }
            String suffix = result.substring(suffixIndex);
            String prefix = cssClass.contains(WIDTH) ? result.substring(0, result.indexOf(WIDTH)) : result.substring(0, suffixIndex);
            result = prefix + " " + cssClass + " " + suffix;
        }
        return result;
    }
}

