/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.utils.SessionContextUtil;
import com.exlibris.core.infra.svc.api.utils.WithSessionContext;
import java.lang.annotation.Annotation;
import javax.annotation.security.RolesAllowed;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class PrivilegesChecker {
    private static final ExLogger log = ExLogger.getExLogger(PrivilegesChecker.class);

    @AroundInvoke
    private Object checkePrivileges(InvocationContext invCtx) throws Exception {
        if (!(invCtx.getTarget() instanceof WithSessionContext)) {
            log.warn((Object)"No session context defined on EJB, allowing access", new String[0]);
            return invCtx.proceed();
        }
        WithSessionContext manager = (WithSessionContext)invCtx.getTarget();
        Annotation[] annotationArr = invCtx.getMethod().getAnnotations();
        if (annotationArr == null) {
            return invCtx.proceed();
        }
        for (Annotation annotation : annotationArr) {
            if (!(annotation instanceof RolesAllowed)) continue;
            String[] privileges = ((RolesAllowed)annotation).value();
            boolean found = SessionContextUtil.searchPrivilegeInContext(manager.getSessionContext(), privileges);
            if (found) {
                return invCtx.proceed();
            }
            throw new InfraException(DescriptorConstants.GN_UnautorizedMethodInvocation, (Object)SessionContextUtil.getUserNameFromSession(manager.getSessionContext()), (Object)invCtx.getTarget().getClass().getSimpleName(), invCtx.getMethod().getName());
        }
        return invCtx.proceed();
    }
}

