/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class DublinCore {
    private static ExLogger log = ExLogger.getExLogger(DublinCore.class);
    public static final int DC_NAMESPACE = 10;
    public static final int DCTERMS_NAMESPACE = 20;
    public static final String DC_PREFIX = "dc";
    public static final String DCTERMS_PERFIX = "dcterms";
    public static final String XSI_TYPE = "xsi:type";
    private Document m_document = null;
    private Element m_record = null;
    private String mid = null;
    public static final Namespace dcNamespace = new Namespace("dc", "http://purl.org/dc/elements/1.1/");
    public static final Namespace dctermsNamespace = new Namespace("dcterms", "http://purl.org/dc/terms/");
    public static final Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace xmlNamespace = new Namespace("xml", "http://www.w3.org/2001/XMLSchema-instance");
    public static final QName XsiQName = new QName("type", xsiNamespace);
    public static final QName XmlQName = new QName("lang", xsiNamespace);
    public static final QName RECORD_NODE_NAME = new QName("record", dcNamespace);

    public static void main(String[] args) throws IOException {
        System.out.println(DublinCoreFactory.getInstance().createDocument().toXml());
        DublinCore DC = DublinCoreFactory.getInstance().createDocument();
        System.out.println(DC.toXml());
    }

    protected DublinCore() {
        this.createNew();
    }

    protected DublinCore(String xml) throws DocumentException {
        this.createFromXml(xml);
    }

    public String getTitle() {
        String label = "";
        label = this.getDcValue("title");
        if (label == null) {
            label = this.getDctermsValue("alternative");
        }
        return label;
    }

    public DublinCore copyDC() throws Exception {
        return new DublinCore(this.toXml());
    }

    private void createFromXml(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.m_document = reader.read((Reader)new StringReader(xml));
        this.m_record = this.m_document.getRootElement();
    }

    private void createNew() {
        this.m_document = DocumentFactory.getInstance().createDocument();
        this.m_record = this.m_document.addElement(RECORD_NODE_NAME);
        this.m_record.add(dcNamespace);
        this.m_record.add(dctermsNamespace);
        this.m_record.add(xsiNamespace);
    }

    public void addNamespace(Namespace namespace) {
        if (namespace == null) {
            return;
        }
        String prefix = namespace.getPrefix();
        if (this.getNamespace(prefix) == null) {
            this.m_record.add(namespace);
        }
    }

    public Namespace getNamespace(String prefix) {
        return this.m_record.getNamespaceForPrefix(prefix);
    }

    @Deprecated
    public void addElement(int namespace, String key, String value) {
        this.addElement(namespace, key, null, value);
    }

    @Deprecated
    public void addElement(int namespace, String key, String xsiType, String value) {
        QName qname = null;
        if (namespace == 10) {
            qname = new QName(key, dcNamespace);
        } else if (namespace == 20) {
            qname = new QName(key, dctermsNamespace);
        } else {
            return;
        }
        Element elem = this.m_record.addElement(qname);
        elem.setText(value);
        if (xsiType != null) {
            elem.addAttribute(XsiQName, xsiType);
        }
    }

    private QName getQNameFromString(String str) {
        if (StringUtils.isEmptyString(str)) {
            return null;
        }
        String[] array = str.split(":");
        if (array == null || array.length != 2) {
            return null;
        }
        Namespace namespace = this.getNamespace(array[0]);
        if (namespace == null) {
            return null;
        }
        return new QName(array[1], namespace);
    }

    public void addElement(String xPathKey, String value) {
        this.addElement(xPathKey, value, null);
    }

    public void addElement(String xPathKey, String value, QName qName) {
        if (qName == null) {
            qName = XsiQName;
        }
        if (StringUtils.isEmptyString(xPathKey)) {
            return;
        }
        String[] array = xPathKey.split("@");
        if (array == null || array.length < 1) {
            return;
        }
        QName qname = this.getQNameFromString(array[0]);
        if (qname == null) {
            return;
        }
        Element elem = this.m_record.addElement(qname);
        elem.setText(value);
        if (array.length >= 2) {
            elem.addAttribute(qName, array[1]);
        }
    }

    public String getDcValue(String key) {
        return this.getValue(10, key, null);
    }

    public String getDctermsValue(String key) {
        return this.getValue(20, key, null);
    }

    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return null;
        }
        return this.getValue(dcElem.namespace, dcElem.key, dcElem.xsiType);
    }

    public List getValues(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return null;
        }
        return this.getValues(dcElem.namespace, dcElem.key, dcElem.xsiType);
    }

    private String getValue(int namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == 10) {
            xpath.append(DC_PREFIX);
        } else if (namespace == 20) {
            xpath.append(DCTERMS_PERFIX);
        } else {
            return null;
        }
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        if (index == null || index.length() == 0) {
            return this.getXPathValue(xpath.toString());
        }
        List list = this.getXPathValues(xpath.toString());
        int i = Integer.parseInt(index) - 1;
        return (String)list.get(i);
    }

    public String getValue(String namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        if (index == null || index.length() == 0) {
            return this.getXPathValue(xpath.toString());
        }
        List list = this.getXPathValues(xpath.toString());
        int i = Integer.parseInt(index) - 1;
        return (String)list.get(i);
    }

    public List getValues(String namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        return this.getXPathValues(xpath.toString());
    }

    public void save(String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.m_document.write((Writer)out);
        out.flush();
        out.close();
    }

    public String toXml() throws IOException {
        StringWriter sw = new StringWriter();
        this.m_document.write((Writer)sw);
        sw.flush();
        sw.close();
        return sw.getBuffer().toString();
    }

    public Document getDocument() {
        return this.m_document;
    }

    private String getXPathValue(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    private List getXPathValues(String xPath) {
        try {
            List nodes = this.m_document.selectNodes(xPath);
            if (nodes != null) {
                ArrayList<String> l = new ArrayList<String>();
                Iterator i = nodes.iterator();
                while (i.hasNext()) {
                    l.add(((Node)i.next()).getText());
                }
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), this.m_document.asXML());
            return null;
        }
    }

    private String getXPath(String namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        return xpath.toString();
    }

    public void removeElemet(String namespace, String key) {
        this.removeElemet(namespace, key, null);
    }

    public void removeElemet(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return;
        }
        this.removeElemet(dcElem.namespace, dcElem.key, dcElem.xsiType);
    }

    public void removeElemet(String namespace, String key, String xsiType) {
        String path = this.getXPath(namespace, key, xsiType);
        this.removeNodeByXPath(path);
    }

    private void removeNodeByXPath(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            node.detach();
        }
    }

    private DCElement parseKey(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        DCElement dcElem = new DCElement();
        int pos = key.indexOf("@");
        if (pos == -1) {
            if (key.length() > 0) {
                String[] fieldParts = key.split(":");
                if (fieldParts.length != 2) {
                    log.warn((Object)("Failed to parse xpath: " + key), new String[0]);
                    return null;
                }
                dcElem.key = fieldParts[1];
                dcElem.namespace = fieldParts[0];
            }
        } else {
            String[] fieldParts = key.substring(0, pos).split(":");
            if (fieldParts.length != 2) {
                log.warn((Object)("Failed to parse xpath: " + key), new String[0]);
                return null;
            }
            dcElem.key = fieldParts[1];
            dcElem.namespace = fieldParts[0];
            dcElem.xsiType = key.substring(pos + 1);
        }
        return dcElem;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public List<String> getElementsXpaths() {
        ArrayList<String> xpaths = new ArrayList<String>();
        Element root = this.m_document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            String tag = null;
            String xsi = null;
            String xpath = null;
            Element element = (Element)i.next();
            tag = element.getNamespacePrefix() + ":" + element.getName();
            Iterator j = element.attributeIterator();
            while (j.hasNext()) {
                Attribute attribute = (Attribute)j.next();
                if (!attribute.getPath().contains(XSI_TYPE)) continue;
                xsi = attribute.getValue();
                break;
            }
            xpath = xsi != null ? tag + "@" + xsi : tag;
            xpaths.add(xpath);
        }
        return xpaths;
    }

    private class DCElement {
        public String namespace;
        public String xsiType;
        public String key;
        public String val;

        private DCElement() {
        }

        public String toString() {
            return "namespace=" + this.namespace + ";key=" + this.key + ";xsiType=" + this.xsiType + ";val=" + this.val;
        }
    }
}

