/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.parser;

import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.core.sdk.parser.CoreIEParser;
import com.exlibris.core.sdk.parser.IEParserException;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dom4j.DocumentException;

public class CoreIEParserImpl
implements CoreIEParser {
    public static final String IE_DMD = "ie-dmd";
    public static final String CMS_DMD = "cms-dmd";
    public static final String COLLECTION_DMD = "collection-dmd";
    public static final String GROUP_ID_PREFIX = "rep";
    public static final String FILE_ID_PREFIX = "fid";
    public static final String STRUCT_MAP_TYPE_PHYSICAL = "PHYSICAL";
    public static final String DIV_TYPE_FILE = "FILE";
    public static final String AMD_SUFFIX = "-amd";
    public static final String STRUCT_MAP_PREFIX = "";
    public static final String TECH_SUFFIX = "-tech";
    public static final String DIGIPROV_SUFFIX = "-digiprov";
    public static final String RIGHTS_SUFFIX = "-rights";
    public static final String SOURCE_SUFFIX = "-source";
    public static final String CONNECTOR = "-";
    private static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";
    private static final String DMD_SUFFIX = "-dmd";
    protected MetsDocument doc;
    protected MetsDocument.Mets mets;
    protected HashMap<String, AmdSecType> amdMap;
    protected HashMap<String, MdSecType> dmdMap;
    protected HashMap<String, MetsType.FileSec.FileGrp> fileGrpMap;
    protected HashMap<String, FileType> fileTypeMap;

    protected CoreIEParserImpl(MetsDocument metsDoc) {
        this.doc = metsDoc;
        this.mets = this.doc.getMets();
    }

    protected MetsDocument.Mets getMets() {
        return this.mets;
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name());
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt) throws IEParserException {
        int newFileGrpCount = this.getFileGrpCount() + 1;
        String id = GROUP_ID_PREFIX + newFileGrpCount;
        if (pt == null) {
            pt = PRESERVATION_MASTER;
        }
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        if (this.mets.getFileSec() == null) {
            this.mets.addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.mets.getFileSec().addNewFileGrp();
        fileGrp.setID(id);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        fileGrp.setADMID(al);
        this.addFileGrpToMap(fileGrp);
        return fileGrp;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, null);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String groupId) throws IEParserException {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = FILE_ID_PREFIX + newFileCount + CONNECTOR + fileGrp.getID().replace(GROUP_ID_PREFIX, STRUCT_MAP_PREFIX);
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        if (!StringUtils.isEmptyString(groupId)) {
            file.setGROUPID(groupId);
        }
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType[] getFileArray(String fileGrpId) {
        MetsType.FileSec.FileGrp fileGrp = this.getFileGrp(fileGrpId);
        if (fileGrp == null) {
            return null;
        }
        FileType[] fileTypes = null;
        fileTypes = fileGrp.getFileArray();
        return fileTypes;
    }

    @Override
    public MetsType.FileSec.FileGrp[] getFileGrpArray() {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        MetsType.FileSec.FileGrp[] fileGrps = null;
        fileGrps = this.mets.getFileSec().getFileGrpArray();
        return fileGrps;
    }

    @Override
    public StructMapType addNewStructMap(String fileGrpId) throws IEParserException {
        StructMapType[] sms = null;
        sms = this.mets.getStructMapArray();
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().equals(fileGrpId + CONNECTOR + 1)) continue;
            this.mets.removeStructMap(i);
            break;
        }
        StructMapType sm = this.mets.addNewStructMap();
        sm.setID(fileGrpId + CONNECTOR + 1);
        sm.setTYPE(STRUCT_MAP_TYPE_PHYSICAL);
        return sm;
    }

    @Override
    public StructMapType[] getStructMapArray() {
        if (this.mets != null) {
            StructMapType[] structMapTypes = null;
            structMapTypes = this.mets.getStructMapArray();
            return structMapTypes;
        }
        return null;
    }

    @Override
    public DublinCore getDublinCoreParser() {
        return DublinCoreFactory.getInstance().createDocument();
    }

    @Override
    public MdSecType[] getDmdSecArray() throws IEParserException {
        if (this.mets != null) {
            MdSecType[] dmdSecArray = null;
            dmdSecArray = this.mets.getDmdSecArray();
            return dmdSecArray;
        }
        return null;
    }

    @Override
    public AmdSecType[] getAmdSecArray() throws IEParserException {
        if (this.mets != null) {
            AmdSecType[] amdSecArray = null;
            amdSecArray = this.mets.getAmdSecArray();
            return amdSecArray;
        }
        return null;
    }

    @Override
    public FileType getFile(String id) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (fileGrps == null) {
            return null;
        }
        this.populateFileTypeMap();
        return this.fileTypeMap.get(id);
    }

    protected void addFileTypeToMap(FileType fileType) {
        this.populateFileTypeMap();
        if (this.fileTypeMap.get(fileType.getID()) == null) {
            this.fileTypeMap.put(fileType.getID(), fileType);
        }
    }

    protected void populateFileTypeMap() {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (this.fileTypeMap == null && this.mets != null) {
            this.fileTypeMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                FileType[] fs = this.getFileArray(fileGrps[i].getID());
                for (int j = 0; j < fs.length; ++j) {
                    this.fileTypeMap.put(fs[j].getID(), fs[j]);
                }
            }
        }
    }

    @Override
    public MetsType.FileSec.FileGrp getFileGrp(String id) {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        this.populateFileGrpMap();
        return this.fileGrpMap.get(id);
    }

    protected void addFileGrpToMap(MetsType.FileSec.FileGrp fileGrp) {
        this.populateFileGrpMap();
        if (this.fileGrpMap.get(fileGrp.getID()) == null) {
            this.fileGrpMap.put(fileGrp.getID(), fileGrp);
        }
    }

    protected void populateFileGrpMap() {
        if (this.fileGrpMap == null && this.mets != null) {
            MetsType.FileSec.FileGrp[] fileGrps = null;
            this.fileGrpMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                this.fileGrpMap.put(fileGrps[i].getID(), fileGrps[i]);
            }
        }
    }

    @Override
    public MetsType.FileSec getFileSec() {
        if (this.mets != null) {
            if (this.mets.getFileSec() == null) {
                this.mets.addNewFileSec();
            }
            return this.mets.getFileSec();
        }
        return null;
    }

    @Override
    public DublinCore getIeDublinCore() throws IEParserException {
        return this.getDMDDC(IE_DMD);
    }

    @Override
    public DublinCore getDMDDC(String dmdId) throws IEParserException {
        this.populateDmdMap();
        MdSecType md = this.getDmdSec(dmdId);
        if (md == null || md.getMdWrap() == null || md.getMdWrap().getXmlData() == null) {
            return null;
        }
        if (((Object)((Object)md.getMdWrap().getMDTYPE())).equals((Object)MdSecType.MdWrap.MDTYPE.DC)) {
            try {
                return DublinCoreFactory.getInstance().createDocument(md.getMdWrap().getXmlData().xmlText());
            }
            catch (DocumentException e) {
                throw new IEParserException(IEParserException.Descriptor.DC_DOCUMENT_EXCEPTION, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setDublinCore(DublinCore dc, String id) throws IEParserException {
        this.setDMDDC(dc, this.formatDmdId(id));
    }

    private String formatDmdId(String id) {
        return id + DMD_SUFFIX;
    }

    @Override
    public void setIEDublinCore(DublinCore dc) throws IEParserException {
        this.setDMDDC(dc, IE_DMD);
    }

    private void setDMDDC(DublinCore dc, String dmdId) throws IEParserException {
        XmlObject xmlObject = null;
        try {
            xmlObject = XmlObject.Factory.parse((String)dc.toXml());
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
        }
        this.generateDmdSec(xmlObject, MdSecType.MdWrap.MDTYPE.DC, dmdId);
    }

    @Override
    public void export(String fileName) throws IEParserException {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        File f = new File(fileName);
        try {
            File parentFile = f.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.doc.save(f, opt);
        }
        catch (IOException e) {
            throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public StructMapType getStructMap(String grpId) {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (smId.startsWith(STRUCT_MAP_PREFIX)) {
                smId = smId.substring(STRUCT_MAP_PREFIX.length());
            }
            if (!structMapArray[i].getTYPE().toUpperCase().equals(STRUCT_MAP_TYPE_PHYSICAL)) continue;
            grpMap = structMapArray[i];
            break;
        }
        if (grpMap == null) {
            grpMap = structMapArray[0];
        }
        return grpMap;
    }

    @Override
    public void generateGID() throws IEParserException {
        if (this.validateCompatible()) {
            MetsType.FileSec.FileGrp[] fileGrp = null;
            try {
                fileGrp = this.mets.getFileSec().getFileGrpArray();
            }
            catch (NullPointerException e) {
                throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
            }
            for (int i = 0; i < fileGrp.length; ++i) {
                FileType[] file = fileGrp[i].getFileArray();
                for (int j = 0; j < file.length; ++j) {
                    file[j].setGROUPID(String.valueOf(j + 1));
                }
            }
        }
    }

    private StructMapType createStructMapType(String value) throws IEParserException {
        StructMapType smt = null;
        try {
            smt = MetsDocument.Factory.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?><mets xmlns=\"http://www.loc.gov/METS/\">" + value + "</mets>").getMets().getStructMapArray(0);
            return smt;
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public void setStructMap(MetsType.FileSec.FileGrp fileGrp, String structMapXml) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        StructMapType newSm = this.createStructMapType(structMapXml);
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = newSm;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public void addAdditionalStructMap(MetsType.FileSec.FileGrp fileGrp, StructMapType newSm) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        int count = 0;
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().substring(0, sms[i].getID().lastIndexOf(CONNECTOR)).equals(fileGrp.getID())) continue;
            ++count;
        }
        newSm.setID(fileGrp.getID() + CONNECTOR + ++count);
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = newSm;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public StructMapType getStructMapById(String structMapId) throws IEParserException {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.equals(structMapId)) continue;
            grpMap = structMapArray[i];
            break;
        }
        return grpMap;
    }

    @Override
    public StructMapType[] getStructMapsByFileGrpId(String fileGrpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        ArrayList<StructMapType> structMapArrayById = new ArrayList<StructMapType>();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(fileGrpId)) continue;
            structMapArrayById.add(structMapArray[i]);
        }
        StructMapType[] structMapsFileGrp = new StructMapType[structMapArrayById.size()];
        structMapsFileGrp = structMapArrayById.toArray(structMapsFileGrp);
        return structMapsFileGrp;
    }

    @Override
    public void removeFGStructMaps(String grpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeStructMap(i);
            this.removeFGStructMaps(grpId);
            break;
        }
    }

    protected void removeFGAmdSec(String grpId) throws IEParserException {
        AmdSecType[] amdSecTypeArray = this.getAmdSecArray();
        for (int i = 0; i < amdSecTypeArray.length; ++i) {
            String id = amdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeAmdSec(i);
            this.removeFGAmdSec(grpId);
            break;
        }
    }

    protected void removeFGDmdSec(String grpId) throws IEParserException {
        MdSecType[] mdSecTypeArray = this.getDmdSecArray();
        for (int i = 0; i < mdSecTypeArray.length; ++i) {
            String id = mdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeDmdSec(i);
            this.removeFGDmdSec(grpId);
            break;
        }
    }

    protected void removeFGSec(String grpId) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = this.getFileSec().getFileGrpArray();
        for (int i = 0; i < fileGrp.length; ++i) {
            String id = fileGrp[i].getID();
            if (!id.equals(grpId)) continue;
            this.mets.getFileSec().removeFileGrp(i);
            break;
        }
    }

    @Override
    public String toXML() {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        return this.doc.xmlText(opt);
    }

    @Override
    public boolean validate(XmlOptions xmloptions) {
        return this.mets.validate(xmloptions);
    }

    @Override
    public boolean validate() {
        return this.mets.validate();
    }

    protected MdSecType getDmdSec(String dmdId) {
        return this.dmdMap.get(dmdId);
    }

    protected AmdSecType getAmd(String id, boolean createNew) {
        AmdSecType amd = null;
        this.populateAmdMap();
        if (this.amdMap.get(id) == null && createNew) {
            amd = this.createNewAmdSec(id);
            this.amdMap.put(amd.getID(), amd);
        }
        return this.amdMap.get(id);
    }

    protected void addAmdSecToMap(AmdSecType amd) {
        this.populateAmdMap();
        if (this.amdMap.get(amd.getID()) == null) {
            this.amdMap.put(amd.getID(), amd);
        }
    }

    protected void populateAmdMap() {
        AmdSecType[] amds = null;
        if (this.amdMap == null) {
            this.amdMap = new HashMap();
            if (this.mets != null) {
                amds = this.mets.getAmdSecArray();
                for (int i = 0; i < amds.length; ++i) {
                    this.amdMap.put(amds[i].getID(), amds[i]);
                }
            }
        }
    }

    private void populateDmdMap() {
        MdSecType[] dmds = null;
        if (this.dmdMap == null) {
            this.dmdMap = new HashMap();
            if (this.mets != null) {
                dmds = this.mets.getDmdSecArray();
                for (int i = 0; i < dmds.length; ++i) {
                    this.dmdMap.put(dmds[i].getID(), dmds[i]);
                }
            }
        }
    }

    protected AmdSecType createNewAmdSec(String id) {
        AmdSecType amd = this.mets.addNewAmdSec();
        amd.setID(id);
        MdSecType md = amd.addNewTechMD();
        md.setID(id + TECH_SUFFIX);
        MdSecType.MdWrap mdWrap = md.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        md = amd.addNewDigiprovMD();
        md.setID(id + DIGIPROV_SUFFIX);
        mdWrap = md.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        md = amd.addNewRightsMD();
        md.setID(id + RIGHTS_SUFFIX);
        mdWrap = md.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        md = amd.addNewSourceMD();
        md.setID(id + SOURCE_SUFFIX);
        mdWrap = md.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        return amd;
    }

    protected XmlObject getXmlObject(String xml) throws IEParserException {
        try {
            return XmlObject.Factory.parse((String)xml);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    protected int getFileGrpCount() throws IEParserException {
        int length;
        if (this.mets.getFileSec() == null) {
            return 0;
        }
        try {
            length = this.mets.getFileSec().getFileGrpArray().length;
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        return length;
    }

    protected int getFileCount(MetsType.FileSec.FileGrp fileGrp) {
        if (fileGrp == null) {
            return 0;
        }
        return fileGrp.getFileArray().length;
    }

    protected boolean validateCompatible() throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length - 1; ++i) {
            if (fileGrp[i].getFileArray().length == fileGrp[i + 1].getFileArray().length) continue;
            return false;
        }
        return true;
    }

    protected void updateAmdIds(String correctId, String currentIdAmdSec) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(currentIdAmdSec, false);
        if (amdSecType != null) {
            amdSecType.setID(correctId + AMD_SUFFIX);
            try {
                amdSecType.getTechMDArray(0).setID(correctId + AMD_SUFFIX + TECH_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getDigiprovMDArray(0).setID(correctId + AMD_SUFFIX + DIGIPROV_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getRightsMDArray(0).setID(correctId + AMD_SUFFIX + RIGHTS_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getSourceMDArray(0).setID(correctId + AMD_SUFFIX + SOURCE_SUFFIX);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void generateDmdSec(XmlObject xmlObject, MdSecType.MdWrap.MDTYPE.Enum mdType, String dmdId) {
        this.populateDmdMap();
        MdSecType dmd = this.getDmdSec(dmdId);
        if (dmd == null) {
            dmd = this.mets.addNewDmdSec();
        } else {
            dmd.unsetMdWrap();
        }
        dmd.setID(dmdId);
        dmd.addNewMdWrap().addNewXmlData().set(xmlObject);
        dmd.getMdWrap().setMDTYPE(mdType);
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid) {
        this.setSourceMd(mid, id + AMD_SUFFIX, mdType, xmlObject);
    }

    @Override
    public void setIeSourceMd(MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject) {
        this.setSourceMd(null, "ie-amd", mdType, xmlObject);
    }

    @Override
    public void setIeSourceMd(MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid) {
        this.setSourceMd(mid, "ie-amd", mdType, xmlObject);
    }

    @Override
    public String getFileDmdId(String id) {
        return this.formatDmdId(id);
    }

    private void setSourceMd(String mid, String amdId, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject) {
        AmdSecType amd = this.getAmd(amdId, true);
        Integer mdNumber = 1;
        if (amd != null) {
            MdSecType[] sourceMDs;
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                if (!((Object)((Object)mdType)).equals((Object)sourceMdWrap.getMDTYPE())) continue;
                Integer n = mdNumber;
                Integer n2 = mdNumber = Integer.valueOf(mdNumber + 1);
            }
        } else {
            amd = this.createNewAmdSec(amdId);
        }
        MdSecType newSourceMD = amd.addNewSourceMD();
        String sourceMDId = null;
        sourceMDId = mid != null ? mid : StringUtils.concat(new Object[]{amdId, "-source-", mdType, CONNECTOR, mdNumber});
        newSourceMD.setID(sourceMDId);
        newSourceMD.addNewMdWrap().addNewXmlData().set(xmlObject);
        newSourceMD.getMdWrap().setMDTYPE(mdType);
        this.addAmdSecToMap(amd);
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject) {
        this.setSourceMd(null, id + AMD_SUFFIX, mdType, xmlObject);
    }

    @Override
    public List<MdSecType.MdWrap> getIeSourceMDs() {
        return this.getSourceMDs("ie-amd");
    }

    @Override
    public List<MdSecType.MdWrap> getSourceMDs(String id) {
        ArrayList<MdSecType.MdWrap> mdWraps = new ArrayList<MdSecType.MdWrap>();
        AmdSecType amd = this.getAmd(id, false);
        if (amd != null) {
            MdSecType[] sourceMDs;
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                if (sourceMdWrap == null || this.isDnxMdWrap(sourceMdWrap)) continue;
                mdWraps.add(sourceMdWrap);
            }
        }
        return mdWraps;
    }

    @Override
    public MdSecType[] getIeSourceMDsArray() {
        AmdSecType amd = this.getAmd("ie-amd", false);
        MdSecType[] sourceMDs = null;
        if (amd != null) {
            sourceMDs = amd.getSourceMDArray();
        }
        return sourceMDs;
    }

    @Override
    public void setIeSourceMds(MdSecType[] sourceMdsArray) {
        AmdSecType amd = this.getAmd("ie-amd", false);
        amd.setSourceMDArray(sourceMdsArray);
    }

    protected boolean isDnxMdWrap(MdSecType.MdWrap mdWrap) {
        return ((Object)((Object)MdSecType.MdWrap.MDTYPE.OTHER)).equals((Object)mdWrap.getMDTYPE()) && "dnx".equals(mdWrap.getOTHERMDTYPE());
    }

    @Override
    public DublinCore getIeCMSDublinCore() throws IEParserException {
        return this.getDMDDC(CMS_DMD);
    }

    @Override
    public void setIeCMSDublinCore(DublinCore dc) throws IEParserException {
        this.setDMDDC(dc, CMS_DMD);
    }
}

