/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static int BUFFER = 2048;
    private static final ExLogger log = ExLogger.getExLogger(ZipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File zipFile, File parentDir, File[] sources, char pathSeparator) throws IOException {
        String stripPath;
        String string = stripPath = parentDir != null ? parentDir.getPath() : "";
        if (stripPath.length() > 0 && !stripPath.endsWith(File.separator)) {
            stripPath = stripPath + File.separator;
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        out.setMethod(8);
        try {
            for (int i = 0; i < sources.length; ++i) {
                if (!sources[i].exists()) {
                    throw new IllegalArgumentException("File or directory does not exist: " + sources[i]);
                }
                if (sources[i].isDirectory()) {
                    ZipUtil.zipDirectory(out, stripPath, sources[i], pathSeparator);
                    continue;
                }
                ZipUtil.zipFile(out, stripPath, sources[i], pathSeparator);
            }
        }
        finally {
            out.close();
        }
    }

    public static void zipFlatDir(String dir2zip, String zipName) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipName));
        try {
            File zipDir = new File(dir2zip);
            File[] f = zipDir.listFiles();
            byte[] readBuffer = new byte[4096];
            int bytesIn = 0;
            for (int i = 0; i < f.length; ++i) {
                FileInputStream fis = new FileInputStream(f[i]);
                ZipEntry anEntry = new ZipEntry(f[i].getName());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
        }
        catch (Exception e) {
            log.error("creating zip File: " + zipName + " failed", e, new String[0]);
            throw new Exception(e);
        }
        zos.close();
    }

    public static HashMap<File, String> unzipDir(File file, boolean override, boolean oneLevelDown) throws Exception {
        int BUFFER = 2048;
        String originalPath = file.getPath();
        String originalParentPath = file.getParent();
        File newZipFile = null;
        if (oneLevelDown) {
            newZipFile = new File(file.getParent() + File.separator + "tmp_" + file.getName());
            file.renameTo(newZipFile);
        } else {
            newZipFile = file;
        }
        HashMap<File, String> fileMap = new HashMap<File, String>();
        try {
            ZipFile zipFile = new ZipFile(newZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    log.info("Extracting directory: " + entry.getName());
                    new File(entry.getName()).mkdir();
                    continue;
                }
                log.info("Extracting file: " + entry.getName());
                String path = null;
                path = oneLevelDown ? originalPath + File.separator + entry.getName() : originalParentPath + File.separator + entry.getName();
                File file2 = new File(path);
                if (file2.exists() && !override) {
                    fileMap.put(file2, null);
                    continue;
                }
                if (!file2.getParentFile().exists()) {
                    file2.getParentFile().mkdirs();
                }
                fileMap.put(file2, entry.getName());
                ZipUtil.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file2)));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            log.error("Unhandled exception:", ioe, new String[0]);
            return null;
        }
        return fileMap;
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void zipFromFilesAndBytes(List<File> files, Map<String, byte[]> zipDataByName, String targetZipFile) throws IOException {
        BufferedInputStream origin = null;
        FileOutputStream dest = new FileOutputStream(targetZipFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        byte[] data = new byte[BUFFER];
        for (File f : files) {
            int count;
            FileInputStream fi = new FileInputStream(f.getAbsolutePath());
            origin = new BufferedInputStream(fi, BUFFER);
            ZipEntry entry = new ZipEntry(ZipUtil.getFileName(f, false));
            entry.setTime(new Date(System.currentTimeMillis()).getTime());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, BUFFER)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        for (String zipEntryName : zipDataByName.keySet()) {
            int count;
            byte[] inEntry = zipDataByName.get(zipEntryName);
            if (inEntry == null) continue;
            ByteArrayInputStream in = new ByteArrayInputStream(inEntry);
            origin = new BufferedInputStream(in, BUFFER);
            ZipEntry entry = new ZipEntry(zipEntryName);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, BUFFER)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        out.close();
    }

    public static List<File> getListFilesFromZip(File zipFile) throws Exception {
        ArrayList<File> listFile = new ArrayList<File>();
        ZipFile zippedFile = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zippedFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path = zipFile.getParent() + File.separator + entry.getName();
            File file = new File(path);
            listFile.add(file);
        }
        zippedFile.close();
        return listFile;
    }

    private static String getFileName(File file, boolean keepDirectoryStructure) {
        if (keepDirectoryStructure) {
            return file.getAbsolutePath();
        }
        return file.getName();
    }

    public static void zipFile(String zipFilename, String fileToZip, String fileOriginalPathAndName, String filePid) throws Exception {
        if (zipFilename == null || zipFilename.length() == 0 || fileToZip == null || fileToZip.length() == 0) {
            throw new Exception("Missing zip file name!");
        }
        try {
            File destination = new File(zipFilename);
            File parentFile = destination.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (FileUtil.isFileExist(zipFilename)) {
                zipFilename = zipFilename + filePid;
            }
            FileOutputStream fos = new FileOutputStream(zipFilename);
            ZipOutputStream zip = new ZipOutputStream(fos);
            zip.setLevel(9);
            zip.setMethod(8);
            File elementFile = new File(fileToZip);
            ZipEntry entry = new ZipEntry(fileOriginalPathAndName);
            entry.setTime(elementFile.lastModified());
            int fileLength = (int)elementFile.length();
            FileInputStream fis = new FileInputStream(elementFile);
            byte[] wholeFile = new byte[fileLength];
            int bytesRead = fis.read(wholeFile, 0, fileLength);
            fis.close();
            zip.putNextEntry(entry);
            zip.write(wholeFile, 0, fileLength);
            zip.closeEntry();
            zip.close();
        }
        catch (Exception e) {
            log.error("Error while zipping file: " + zipFilename, e, new String[0]);
            throw new Exception(e);
        }
    }

    private static void zipDirectory(ZipOutputStream out, String stripPath, File dir, char pathSeparator) throws IOException {
        String[] entries = dir.list();
        if (entries == null || entries.length == 0) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            File file = new File(dir, entries[i]);
            if (file.isDirectory()) {
                ZipUtil.zipDirectory(out, stripPath, file, pathSeparator);
                continue;
            }
            ZipUtil.zipFile(out, stripPath, file, pathSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(ZipOutputStream out, String stripPath, File file, char pathSeparator) throws IOException {
        ZipEntry ze = new ZipEntry(ZipUtil.processPath(file.getPath(), stripPath, pathSeparator));
        ze.setTime(file.lastModified());
        out.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), buffer.length);
        try {
            int count = 0;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                if (count == 0) continue;
                out.write(buffer, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    private static String processPath(String path, String stripPath, char pathSeparator) {
        if (!path.startsWith(stripPath)) {
            throw new IllegalArgumentException("Invalid entry: " + path + "; expected to start with " + stripPath);
        }
        return path.substring(stripPath.length()).replace(File.separatorChar, pathSeparator);
    }

    public static void main(String[] args) throws Exception {
        ZipUtil zipUtil = new ZipUtil();
        String zipFilename = "C:/Temp/zipTestDir/out.zip";
        String fileToZip = "D:/aborowsk/Desktop/anna.zip";
        String fileOriginalPath = "c:/Temp/admin1/import/streams/anna.zip";
        try {
            ZipUtil.zipFile("C:/Temp/zipTestDir/out.zip", fileToZip, fileOriginalPath, "FL2002");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

