/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DNXProfile;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class DnxDocumentFactory {
    private static DNXProfile dnxProfile = null;
    private static final DnxDocumentFactory factory = new DnxDocumentFactory();
    static Namespace DNX_NS = new Namespace(null, "http://www.exlibrisgroup.com/dps/dnx");
    static QName DNX_ROOT_QNAME = new QName("dnx", DNX_NS);

    private DnxDocumentFactory() {
        try {
            dnxProfile = new DNXProfile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DNXProfile getDNXProfile() {
        return dnxProfile;
    }

    public static DnxDocumentFactory getInstance() {
        return factory;
    }

    public DnxDocument createDnxDocument() {
        Document document = DocumentFactory.getInstance().createDocument();
        document.addElement(DNX_ROOT_QNAME);
        return new DnxDocument(document, dnxProfile);
    }

    public DnxDocument parse(String xml) {
        Document domDocument = this.getDomDocument(xml);
        DnxDocument doc = this.createDnxDocument();
        this.parseRoot(domDocument.getRootElement(), doc);
        return doc;
    }

    private Document getDomDocument(String xml) {
        SAXReader reader = new SAXReader();
        Document domDocument = null;
        try {
            domDocument = reader.read((Reader)new StringReader(xml));
        }
        catch (Throwable t) {
            throw new RuntimeException("failed to parse xml: " + t.getMessage());
        }
        if (domDocument == null) {
            throw new RuntimeException("failed to parse xml");
        }
        Element root = domDocument.getRootElement();
        if (root == null) {
            throw new RuntimeException("failed to parse xml: missing root element");
        }
        return domDocument;
    }

    private void parseRoot(Element root, DnxDocument doc) {
        Iterator iterator = root.elementIterator(DnxDocument.SECTION);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element domSection = (Element)iterator.next();
            String id = domSection.attributeValue(DnxDocument.ID);
            if (id == null) continue;
            DnxSection dnxSection = doc.createSection(id);
            this.parseSection(domSection, dnxSection);
        }
    }

    private void parseSection(Element domSection, DnxSection dnxSection) {
        Iterator iterator = domSection.elementIterator(DnxDocument.RECORD);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element domRecord = (Element)iterator.next();
            DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
            this.parseRecord(domRecord, dnxSectionRecord);
        }
    }

    private void parseRecord(Element domRecord, DnxSectionRecord dnxSectionRecord) {
        Iterator iterator = domRecord.elementIterator(DnxDocument.KEY);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element domKey = (Element)iterator.next();
            String id = domKey.attributeValue(DnxDocument.ID);
            String q1 = domKey.attributeValue(DnxDocument.Q1);
            String q2 = domKey.attributeValue(DnxDocument.Q2);
            String value = domKey.getText();
            if (id == null) continue;
            dnxSectionRecord.createKey(id, q1, q2, value);
        }
    }

    public static void main(String[] args) throws Exception {
        DnxDocument doc = DnxDocumentFactory.getInstance().createDnxDocument();
        doc.updateSectionKey(DNXConstants.OBJECTIDENTIFIER.OBJECTIDENTIFIERTYPE, "PID");
        doc.updateSectionKey(DNXConstants.OBJECTIDENTIFIER.OBJECTIDENTIFIERVALUE, "15");
        doc.updateSectionKey(DNXConstants.CMS.RECORDID, "11115");
        doc.updateSectionKey(DNXConstants.ACCESSRIGHTSPOLICY.POLICYID, "100");
        doc.updateSectionKey(DNXConstants.PRODUCER.ADDRESS1, "add1");
        doc.updateSectionKey(DNXConstants.PRODUCER.ADDRESS2, "add2");
        String xml = null;
        xml = doc.toString();
        System.out.println("...xml" + xml);
        xml = doc.getDnxDocumentForTechMd().toString();
        System.out.println("...xml" + xml);
        xml = doc.getDnxDocumentForDigiprovMd().toString();
        System.out.println("...xml" + xml);
        xml = doc.getDnxDocumentForRightshMd().toString();
        System.out.println("...xml" + xml);
        DnxDocument doc2 = DnxDocumentFactory.getInstance().createDnxDocument();
        doc2.mergeDnxDocuments(doc.getDnxDocumentForTechMd(), doc.getDnxDocumentForDigiprovMd(), doc.getDnxDocumentForRightshMd(), doc.getDnxDocumentForSourceMd());
        System.out.println("...xml" + doc2.toString());
        try {
            DNXProfile p = new DNXProfile();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

