/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.threadPool;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class DigitoolThreadPool {
    private int threadCount = -1;
    private int threadPriority = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List workers;
    private LinkedList availableWorkers = new LinkedList();
    private LinkedList busyWorkers = new LinkedList();
    private String threadNamePrefix = "DigitoolThreadPoolWorker";
    private static final ExLogger log = ExLogger.getExLogger(DigitoolWorkerThread.class);

    public DigitoolThreadPool() {
    }

    public DigitoolThreadPool(int threadCount, int threadPriority) {
        this.setThreadCount(Math.max(1, threadCount));
        this.setThreadPriority(threadPriority);
    }

    public ExLogger getLog() {
        return log;
    }

    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void initialize(Observer observer) throws Exception {
        if (this.threadCount <= 0) {
            throw new Exception("Thread count must be > 0");
        }
        if (this.threadPriority <= 0 || this.threadPriority > 9) {
            throw new Exception("Thread priority must be > 0 and <= 9");
        }
        ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
        while (!parent.getName().equals("main")) {
            this.threadGroup = parent;
            parent = this.threadGroup.getParent();
        }
        this.threadGroup = new ThreadGroup(parent, "DigitoolThreadPool");
        for (DigitoolWorkerThread dwt : this.createWorkerThreads(this.threadCount)) {
            if (observer != null) {
                dwt.addObserver(observer);
            }
            this.availableWorkers.add(dwt);
        }
    }

    protected List createWorkerThreads(int count) {
        this.workers = new LinkedList();
        for (int i = 1; i <= count; ++i) {
            DigitoolWorkerThread dwt = new DigitoolWorkerThread(this.threadGroup, this.getThreadNamePrefix() + "-" + i, this.getThreadPriority());
            this.workers.add(dwt);
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForWorkerToComplete) {
        this.getLog().debug((Object)"Pool - Got shutdown signal.", new String[0]);
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.isShutdown = true;
            for (DigitoolWorkerThread dwt : this.workers) {
                dwt.shutdown();
                this.availableWorkers.remove(dwt);
            }
            this.nextRunnableLock.notifyAll();
            if (waitForWorkerToComplete) {
                while (this.handoffPending) {
                    try {
                        this.nextRunnableLock.wait(100L);
                    }
                    catch (Throwable t) {}
                }
                while (this.busyWorkers.size() > 0) {
                    this.printBusyWorkers();
                    try {
                        this.nextRunnableLock.wait(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                try {
                    this.nextRunnableLock.wait(2000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                int activeCount = this.threadGroup.activeCount();
                if (activeCount > 0) {
                    this.getLog().info("There are still " + activeCount + " worker threads active.");
                }
                this.getLog().debug((Object)"Pool - shutdown complete", new String[0]);
            }
        }
    }

    private void printBusyWorkers() {
        Iterator workerThreads = this.busyWorkers.iterator();
        this.getLog().debug((Object)"====== printBusyWorkers =============", new String[0]);
        while (workerThreads.hasNext()) {
            DigitoolWorkerThread dwt = (DigitoolWorkerThread)workerThreads.next();
            this.getLog().debug((Object)("Pool - Waiting for thread " + dwt.getName() + " to shut end"), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availableWorkers.size() < 1 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(10L);
                }
                catch (InterruptedException ignore) {}
            }
            if (!this.isShutdown) {
                DigitoolWorkerThread dwt = (DigitoolWorkerThread)this.availableWorkers.removeFirst();
                boolean added = this.busyWorkers.add(dwt);
                this.getLog().debug((Object)("Pool - adding " + dwt.getName() + " to busyWorkers. added=" + added), new String[0]);
                dwt.run(runnable);
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while ((this.availableWorkers.size() < 1 || this.handoffPending) && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.availableWorkers.size();
        }
    }

    protected synchronized void makeAvailable(DigitoolWorkerThread dwt) {
        if (!this.isShutdown) {
            this.availableWorkers.add(dwt);
        }
        boolean removed = this.busyWorkers.remove(dwt);
        this.getLog().debug((Object)("Pool - Removing " + dwt.getName() + " from busyWorkers. removed=" + removed), new String[0]);
    }

    protected void finalize() {
        if (!this.isShutdown) {
            this.shutdown(true);
        }
    }

    class DigitoolWorkerThread
    extends Observable
    implements Runnable {
        private boolean run = true;
        private Runnable runnable = null;
        private String name = null;

        DigitoolWorkerThread(ThreadGroup threadGroup, String name, int priority) {
            Thread threadWorker = new Thread(threadGroup, this, name);
            threadWorker.setPriority(priority);
            threadWorker.start();
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void shutdown() {
            DigitoolThreadPool.this.getLog().debug((Object)("Thread \"" + this.getName() + "\" Got shutDown signal."), new String[0]);
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable newRunnable) {
            DigitoolWorkerThread digitoolWorkerThread = this;
            synchronized (digitoolWorkerThread) {
                if (this.runnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.runnable = newRunnable;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DigitoolThreadPool.this.getLog().debug((Object)("Thread \"" + this.getName() + "\" is up and awake!"), new String[0]);
            boolean ran = false;
            while (this.run) {
                try {
                    DigitoolWorkerThread digitoolWorkerThread = this;
                    synchronized (digitoolWorkerThread) {
                        while (this.runnable == null && this.run) {
                            DigitoolThreadPool.this.getLog().debug((Object)("Thread \"" + this.getName() + "\" sees no work...sleep to 10 millis"), new String[0]);
                            this.wait(10L);
                        }
                    }
                    if (this.runnable == null) continue;
                    DigitoolThreadPool.this.getLog().debug((Object)("Thread \"" + this.getName() + "\" see new work"), new String[0]);
                    ran = true;
                    this.runnable.run();
                }
                catch (InterruptedException unblock) {
                    try {
                        DigitoolThreadPool.this.getLog().error("worker threat got interrupted.", unblock, new String[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                catch (Exception exceptionInRunnable) {
                    try {
                        DigitoolThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable, new String[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.runnable = null;
                    if (!ran) continue;
                    ran = false;
                    DigitoolThreadPool.this.makeAvailable(this);
                }
            }
            DigitoolThreadPool.this.getLog().debug((Object)("Thread \"" + this.getName() + "\" done running"), new String[0]);
        }
    }
}

