/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.deposit;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.parser.CoreIEParserImpl;
import com.exlibris.core.sdk.parser.IEParserException;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.infrastructure.utils.Checksummer;
import com.exlibris.digitool.repository.dataObjects.ExtendedFileWrapper;
import com.exlibris.dps.sdk.deposit.IEParser;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.DivType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class IEParserImpl
extends CoreIEParserImpl
implements IEParser {
    private static final ExLogger log = ExLogger.getExLogger(IEParser.class);
    private static final String IE = "ie";
    public static final String STRUCT_MAP_TYPE = "PHYSICAL";
    public static final String DIV1_LABEL = "collection";
    public static final String AMD_SUFFIX = "-amd";
    public static final String DMD_SUFFIX = "-dmd";
    public static final String STRUCT_MAP_PREFIX = "";
    public static final String TECH_SUFFIX = "-tech";
    public static final String BITSTREAM = "-bitstream";
    public static final String DIGIPROV_SUFFIX = "-digiprov";
    public static final String RIGHTS_SUFFIX = "-rights";
    public static final String SOURCE_SUFFIX = "-source";
    public static final String FILE_PREFIX = "file://";
    public static final String CONNECTOR = "-";
    private static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";

    public IEParserImpl(MetsDocument metsDoc) {
        super(metsDoc);
    }

    @Override
    protected MetsDocument.Mets getMets() {
        return this.mets;
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt) throws IEParserException {
        int newFileGrpCount = this.getFileGrpCount() + 1;
        String id = "rep" + newFileGrpCount;
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALREPCHARACTERISTICS.PRESERVATIONTYPE, pt);
        dnx.updateSectionKey(DNXConstants.GENERALREPCHARACTERISTICS.USAGETYPE, ut.name());
        return this.addNewFileGrp(ut, pt, id, dnx);
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name());
    }

    @Override
    public AmdSecType getBitStreamsSection(String fileContainerId) throws IEParserException {
        return this.getAmd(fileContainerId + BITSTREAM + AMD_SUFFIX, false);
    }

    @Override
    public MdSecType[] getBitStreamSections(String byteStreamId) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(byteStreamId + BITSTREAM + AMD_SUFFIX, false);
        if (amdSecType == null) {
            return new MdSecType[0];
        }
        return amdSecType.getTechMDArray();
    }

    @Override
    public AmdSecType addBitStreamsSection(String byteStreamId) {
        AmdSecType amdSecType = this.mets.addNewAmdSec();
        amdSecType.setID(byteStreamId + BITSTREAM + AMD_SUFFIX);
        this.addAmdSecToMap(amdSecType);
        return amdSecType;
    }

    @Override
    public void addBitStream(String byteStreamId, String bitStreamId, DnxDocument dnx) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(byteStreamId + BITSTREAM + AMD_SUFFIX, true);
        MdSecType mdSecType = amdSecType.addNewTechMD();
        MdSecType.MdWrap mdWrap = mdSecType.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        mdSecType.setID(byteStreamId + BITSTREAM + CONNECTOR + bitStreamId + AMD_SUFFIX + TECH_SUFFIX);
        XmlObject xObj = this.getXmlObject(dnx.getDnxDocumentForTechMd().toString());
        mdSecType.getMdWrap().getXmlData().set(xObj);
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt, String id, DnxDocument dnx) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name(), id, dnx);
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt, String id, DnxDocument dnx) throws IEParserException {
        if (pt == null) {
            pt = PRESERVATION_MASTER;
        }
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        if (this.mets.getFileSec() == null) {
            this.mets.addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.mets.getFileSec().addNewFileGrp();
        fileGrp.setID(id);
        this.setDnx(id, dnx);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        fileGrp.setADMID(al);
        this.addFileGrpToMap(fileGrp);
        return fileGrp;
    }

    @Override
    public DnxDocument getDnxParser() {
        return DnxDocumentFactory.getInstance().createDnxDocument();
    }

    @Override
    public DnxDocument getFileDnx(String id) throws IEParserException {
        if (this.mets != null && this.getFile(id) != null && this.getFile(id).getADMID() != null) {
            return this.getDnx((String)this.getFile(id).getADMID().get(0));
        }
        return null;
    }

    @Override
    public DnxDocument getFileGrpDnx(String id) throws IEParserException {
        if (this.mets != null) {
            return this.getDnx((String)this.getFileGrp(id).getADMID().get(0));
        }
        return null;
    }

    @Override
    public DnxDocument getIeDnx() throws IEParserException {
        if (this.mets != null) {
            return this.getDnx("ie-amd");
        }
        return null;
    }

    @Override
    public void setFileDnx(DnxDocument dnx, String id) throws IEParserException {
        this.setDnx(id, dnx);
        FileType file = this.getFile(id);
        if (file != null && file.getADMID() == null) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(file.getID() + AMD_SUFFIX);
            file.setADMID(al);
        }
    }

    @Override
    public void setFileGrpDnx(DnxDocument dnx, String id) throws IEParserException {
        this.setDnx(id, dnx);
    }

    @Override
    public void setIeDnx(DnxDocument dnx) throws IEParserException {
        this.setDnx(IE, dnx);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label) throws IEParserException {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = "fid" + newFileCount + CONNECTOR + fileGrp.getID().replace("rep", STRUCT_MAP_PREFIX);
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.LABEL, label);
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILEMIMETYPE, mimeType);
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, id, dnx);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String groupId) throws IEParserException {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = "fid" + newFileCount + CONNECTOR + fileGrp.getID().replace("rep", STRUCT_MAP_PREFIX);
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.LABEL, label);
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILEMIMETYPE, mimeType);
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, groupId, id, dnx);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, DnxDocument dnx) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        this.setDnx(id, dnx);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, String groupId, DnxDocument dnx, boolean isDCValid) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        if (!StringUtils.isEmptyString(groupId)) {
            file.setGROUPID(groupId);
        }
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        this.setDnx(id, dnx);
        if (isDCValid) {
            ArrayList<String> al1 = new ArrayList<String>();
            al1.add(this.getFileDmdId(id));
            file.setDMDID(al1);
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, String groupId, DnxDocument dnx) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, id, groupId, dnx, false);
    }

    @Override
    public void fixIdNaming() throws IEParserException {
        boolean beenChanged = false;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            beenChanged = false;
            int fileGrpCount = i + 1;
            String correctFileGrpId = "rep" + fileGrpCount;
            if (!fileGrp[i].getID().equals(correctFileGrpId)) {
                if (fileGrp[i].getADMID().get(0).toString() != null) {
                    this.updateAmdIds(correctFileGrpId, fileGrp[i].getADMID().get(0).toString());
                }
                fileGrp[i].setID(correctFileGrpId);
                beenChanged = true;
            }
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                int fileCount = j + 1;
                String correctFileId = "fid" + fileCount + CONNECTOR + fileGrp[i].getID().replace("rep", STRUCT_MAP_PREFIX);
                if (file[j].getID().equals(correctFileId)) continue;
                if (file[j].getADMID().get(0).toString() != null) {
                    this.updateAmdIds(correctFileId, file[j].getADMID().get(0).toString());
                }
                file[j].setID(correctFileId);
                beenChanged = true;
            }
            if (!beenChanged) continue;
            this.generateStructMap(fileGrp[i], this.getStructMapLabel(fileGrp[i].getID()));
        }
    }

    private String getStructMapLabel(String grpId) {
        String grpLabel = null;
        StructMapType smt = this.getStructMap(grpId);
        if (smt != null) {
            grpLabel = smt.getDiv().getLabel();
        }
        return grpLabel;
    }

    @Override
    public void generateChecksum(String filesRootFolder, String checksumType) throws IEParserException {
        String fullPath = null;
        DnxDocument dnx = null;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                FileType.FLocat[] flocat = file[j].getFLocatArray();
                for (int k = 0; k < flocat.length; ++k) {
                    if (!((Object)((Object)flocat[k].getLOCTYPE())).equals((Object)FileType.FLocat.LOCTYPE.URL)) continue;
                    String path = flocat[k].getDomNode().getAttributes().getNamedItem("href").getNodeValue();
                    if (path.toLowerCase().startsWith(FILE_PREFIX)) {
                        path = path.substring(7);
                    }
                    if (path.trim().charAt(0) != File.separatorChar) {
                        path = File.separator + path;
                    }
                    fullPath = filesRootFolder + path;
                }
                File def = new File(fullPath);
                Checksummer mcs = null;
                try {
                    mcs = new Checksummer(def);
                }
                catch (FileNotFoundException e) {
                    throw new IEParserException(IEParserException.Descriptor.FILE_NOT_FOUND_EXCEPTION, (Throwable)e);
                }
                catch (IOException e) {
                    throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
                }
                dnx = this.getFileDnx(file[j].getID());
                dnx = dnx == null ? DnxDocumentFactory.getInstance().createDnxDocument() : dnx;
                dnx.updateSectionKey(DNXConstants.FILEFIXITY.FIXITYTYPE, checksumType);
                try {
                    dnx.updateSectionKey(DNXConstants.FILEFIXITY.FIXITYVALUE, mcs.getChecksum(checksumType));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IEParserException(IEParserException.Descriptor.NO_SUCH_ALGORITHM_EXCEPTION, (Throwable)e);
                }
                this.setDnx(file[j].getID(), dnx);
                if (file[j].getADMID() != null) continue;
                ArrayList<String> al = new ArrayList<String>();
                al.add(file[j].getID() + AMD_SUFFIX);
                file[j].setADMID(al);
            }
        }
    }

    @Override
    public void updateSize(String filesRootFolder) throws IEParserException {
        String fullPath = null;
        DnxDocument dnx = null;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                FileType.FLocat[] flocat = file[j].getFLocatArray();
                for (int k = 0; k < flocat.length; ++k) {
                    if (!((Object)((Object)flocat[k].getLOCTYPE())).equals((Object)FileType.FLocat.LOCTYPE.URL)) continue;
                    String path = flocat[k].getDomNode().getAttributes().getNamedItem("href").getNodeValue();
                    if (path.toLowerCase().startsWith(FILE_PREFIX)) {
                        path = path.substring(7);
                    }
                    if (path.trim().charAt(0) != File.separatorChar) {
                        path = File.separator + path;
                    }
                    fullPath = filesRootFolder + path;
                }
                File def = new File(fullPath);
                dnx = this.getFileDnx(file[j].getID());
                dnx = dnx == null ? DnxDocumentFactory.getInstance().createDnxDocument() : dnx;
                dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILESIZEBYTES, String.valueOf(def.length()));
                this.setDnx(file[j].getID(), dnx);
                if (file[j].getADMID() != null) continue;
                ArrayList<String> al = new ArrayList<String>();
                al.add(file[j].getID() + AMD_SUFFIX);
                file[j].setADMID(al);
            }
        }
    }

    private StructMapType createStructMapType(String value) throws IEParserException {
        StructMapType smt = null;
        try {
            smt = MetsDocument.Factory.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?><mets xmlns=\"http://www.loc.gov/METS/\">" + value + "</mets>").getMets().getStructMapArray(0);
            return smt;
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public void generateStructMap(MetsType.FileSec.FileGrp fileGrp, String label) throws IEParserException {
        String generatedStructMapDiv2Label = "Table of Contents";
        this.generateStructMap(fileGrp, label, generatedStructMapDiv2Label);
    }

    @Override
    public void generateStructMap(MetsType.FileSec.FileGrp fileGrp, String label1, String label2) throws IEParserException {
        if (fileGrp == null) {
            MetsType.FileSec.FileGrp[] fileGrp2 = null;
            try {
                fileGrp2 = this.mets.getFileSec().getFileGrpArray();
            }
            catch (NullPointerException e) {
                throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
            }
            for (int i = 0; i < fileGrp2.length; ++i) {
                this.generateStructMapFileGrp(fileGrp2[i], label1, label2);
            }
        } else {
            this.generateStructMapFileGrp(fileGrp, label1, label2);
        }
    }

    private DnxDocument getDnx(AmdSecType amd) throws IEParserException {
        DnxDocument techMdDnx = null;
        DnxDocument digiprovMdDnx = null;
        DnxDocument rightsMdDnx = null;
        DnxDocument sourceMdDnx = null;
        try {
            if (amd.getTechMDArray().length != 0) {
                MdSecType.MdWrap techMdWrap = amd.getTechMDArray(0).getMdWrap();
                techMdDnx = this.getDnxFromMdWrap(techMdWrap);
            }
            if (amd.getDigiprovMDArray().length != 0) {
                MdSecType.MdWrap digiprovMdWrap = amd.getDigiprovMDArray(0).getMdWrap();
                digiprovMdDnx = this.getDnxFromMdWrap(digiprovMdWrap);
            }
            if (amd.getRightsMDArray().length != 0 && amd.getRightsMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap rightsMdWrap = amd.getRightsMDArray(0).getMdWrap();
                rightsMdDnx = this.getDnxFromMdWrap(rightsMdWrap);
            }
            if (amd.getSourceMDArray().length != 0 && amd.getSourceMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap sourceMdWrap = amd.getSourceMDArray(0).getMdWrap();
                sourceMdDnx = this.getDnxFromMdWrap(sourceMdWrap);
            }
        }
        catch (Exception e) {
            log.error("Failed parsing dnx metadata from METS amd sec " + amd.getID(), new String[0]);
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.mergeDnxDocuments(techMdDnx, digiprovMdDnx, rightsMdDnx, sourceMdDnx);
        return dnx;
    }

    private DnxDocument getDnxFromMdWrap(MdSecType.MdWrap mdWrap) {
        DnxDocument dnx = null;
        if (mdWrap != null && this.isDnxMdWrap(mdWrap)) {
            dnx = DnxDocumentFactory.getInstance().parse(mdWrap.getXmlData().xmlText());
        }
        return dnx;
    }

    private DnxDocument getDnx(String id) throws IEParserException {
        if (this.getAmd(id, false) != null) {
            return this.getDnx(this.getAmd(id, false));
        }
        return null;
    }

    private void setDnx(String id, DnxDocument dnx) throws IEParserException {
        MdSecType.MdWrap mdWrap;
        XmlObject xObj;
        if (dnx == null) {
            return;
        }
        AmdSecType amd = this.getAmd(id + AMD_SUFFIX, true);
        try {
            xObj = this.getXmlObject(dnx.getDnxDocumentForTechMd().toString());
            if (amd.getTechMDArray().length == 0) {
                mdWrap = amd.addNewTechMD().addNewMdWrap();
                mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
                mdWrap.setOTHERMDTYPE("dnx");
                mdWrap.addNewXmlData().set(xObj);
            } else {
                amd.getTechMDArray(0).getMdWrap().getXmlData().set(xObj);
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
        }
        try {
            xObj = this.getXmlObject(dnx.getDnxDocumentForDigiprovMd().toString());
            if (amd.getDigiprovMDArray().length == 0) {
                mdWrap = amd.addNewDigiprovMD().addNewMdWrap();
                mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
                mdWrap.setOTHERMDTYPE("dnx");
                mdWrap.addNewXmlData().set(xObj);
            } else {
                amd.getDigiprovMDArray(0).getMdWrap().getXmlData().set(xObj);
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
        }
        try {
            xObj = this.getXmlObject(dnx.getDnxDocumentForRightshMd().toString());
            if (amd.getRightsMDArray().length == 0) {
                mdWrap = amd.addNewRightsMD().addNewMdWrap();
                mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
                mdWrap.setOTHERMDTYPE("dnx");
                mdWrap.addNewXmlData().set(xObj);
            } else {
                amd.getRightsMDArray(0).getMdWrap().getXmlData().set(xObj);
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
        }
        try {
            xObj = this.getXmlObject(dnx.getDnxDocumentForSourceMd().toString());
            if (amd.getSourceMDArray().length == 0) {
                mdWrap = amd.addNewSourceMD().addNewMdWrap();
                mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
                mdWrap.setOTHERMDTYPE("dnx");
                mdWrap.addNewXmlData().set(xObj);
            } else {
                amd.getSourceMDArray(0).getMdWrap().getXmlData().set(xObj);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void generateStructMapFileGrp(MetsType.FileSec.FileGrp fileGrp, String label1, String label2) throws IEParserException {
        ArrayList<ExtendedFileWrapper> filesArray = new ArrayList<ExtendedFileWrapper>();
        FileType[] file = fileGrp.getFileArray();
        for (int i = 0; i < file.length; ++i) {
            ExtendedFileWrapper fileWrapper = new ExtendedFileWrapper(null, null, null, this.getFileDisplay(file[i].getID()), null, null, null, file[i].getID(), null);
            filesArray.add(fileWrapper);
        }
        DnxDocument dnx = null;
        StructMapType structMap = this.addNewStructMap(fileGrp.getID());
        dnx = this.getFileGrpDnx(fileGrp.getID());
        if (label1 == null) {
            label1 = this.getDefaultLabel(dnx);
        }
        structMap = this.buildStructMap(fileGrp.getID(), filesArray, label1, label2);
    }

    private String getFileDisplay(String fileID) {
        String fileDisplay = fileID;
        try {
            DnxDocument dnx = this.getFileDnx(fileID);
            if (dnx != null && ((fileDisplay = dnx.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.LABEL)) == null || fileDisplay.equals(STRUCT_MAP_PREFIX)) && (fileDisplay = dnx.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.FILEORIGINALNAME)) != null) {
                fileDisplay = fileDisplay.substring(fileDisplay.lastIndexOf(92) + 1);
                fileDisplay = fileDisplay.substring(fileDisplay.lastIndexOf(47) + 1);
            }
        }
        catch (IEParserException e) {
            e.printStackTrace();
        }
        return fileDisplay;
    }

    @Override
    public String getDefaultLabel(DnxDocument dnx) {
        String preservationLevel = dnx.getDnxDocumentForTechMd().getSectionKeyValue(DNXConstants.GENERALREPCHARACTERISTICS.PRESERVATIONTYPE);
        String usageType = dnx.getDnxDocumentForTechMd().getSectionKeyValue(DNXConstants.GENERALREPCHARACTERISTICS.USAGETYPE);
        String label = preservationLevel + ";" + usageType;
        return label;
    }

    @Override
    public void enrichExternalSM() {
        StructMapType[] structMaps = this.getStructMapArray();
        for (int i = 0; i < structMaps.length; ++i) {
            StructMapType structMap = structMaps[i];
            this.enrichFilesInStructMap(structMap.getDiv(), null);
        }
    }

    @Override
    public ArrayList<String> getFilesArray(StructMapType smType) {
        DivType smDiv = smType.getDiv();
        ArrayList<String> fileList = new ArrayList<String>();
        List<DivType.Fptr> files = this.getFilesFromStructMap(smDiv);
        for (DivType.Fptr file : files) {
            fileList.add(file.getFILEID());
        }
        return fileList;
    }

    @Override
    public List<DivType.Fptr> getFilesFromStructMap(DivType smDiv) {
        List files1 = Arrays.asList(smDiv.getFptrArray());
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            List<DivType.Fptr> files2 = this.getFilesFromStructMap(divTypes[j]);
            files1 = ListUtils.union(files1, files2);
        }
        return files1;
    }

    @Override
    public List<Map<String, String>> getFilesFromStructMapInfo(DivType smDiv) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
        String label = smDiv.getLABEL();
        for (DivType.Fptr fptr : files1) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(fptr.getFILEID(), label);
            list.add(map);
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            List<Map<String, String>> files2 = this.getFilesFromStructMapInfo(divTypes[j]);
            list = ListUtils.union(list, files2);
        }
        return list;
    }

    @Override
    public StructMapType buildStructMap(String repId, List<ExtendedFileWrapper> files, String label1, String label2) throws IEParserException {
        StructMapType structMap = this.addNewStructMap(repId);
        DivType div1 = structMap.addNewDiv();
        div1.setLABEL(label1);
        DivType div2 = div1.addNewDiv();
        div2.setLABEL(label2);
        for (ExtendedFileWrapper file : files) {
            DivType div3 = div2.addNewDiv();
            div3.setLABEL(file.getFileLabel());
            div3.setTYPE("FILE");
            div3.addNewFptr().setFILEID(file.getDestFilePid());
        }
        return structMap;
    }

    @Override
    public DivType enrichFilesInStructMap(DivType smDiv, HashMap<String, String> fileLabelsMap) {
        if (!(smDiv.getTYPE() != null && smDiv.getTYPE().toUpperCase().toUpperCase().equals("FILE") || smDiv.getFptrArray().length <= 0)) {
            List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
            for (DivType.Fptr file : files1) {
                DivType fileDiv = smDiv.addNewDiv();
                fileDiv.setTYPE("FILE");
                if (fileLabelsMap != null) {
                    fileDiv.setLABEL(fileLabelsMap.get(file.getFILEID()));
                } else {
                    fileDiv.setLABEL(this.getFileDisplay(file.getFILEID()));
                }
                DivType.Fptr[] fptrArray = new DivType.Fptr[]{file};
                fileDiv.setFptrArray(fptrArray);
            }
            smDiv.setFptrArray(new DivType.Fptr[0]);
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            this.enrichFilesInStructMap(divTypes[j], fileLabelsMap);
        }
        return smDiv;
    }

    @Override
    public DivType removeFilesFromSM(DivType smDiv, List<String> filesToRemovePID) {
        ArrayList<String> localfilesToRemovePID = new ArrayList<String>(filesToRemovePID);
        DivType[] divTypes = smDiv.getDivArray();
        ArrayList<DivType> validDivTypes = new ArrayList<DivType>();
        for (int j = 0; j < divTypes.length; ++j) {
            if (divTypes[j].getTYPE() == null || !divTypes[j].getTYPE().toUpperCase().equals("FILE") || !localfilesToRemovePID.contains(divTypes[j].getFptrArray(0).getFILEID())) {
                validDivTypes.add(divTypes[j]);
                continue;
            }
            localfilesToRemovePID.remove(divTypes[j].getFptrArray(0).getFILEID());
        }
        DivType[] validDiv = new DivType[validDivTypes.size()];
        validDiv = validDivTypes.toArray(validDiv);
        smDiv.setDivArray(validDiv);
        DivType.Fptr[] files1 = smDiv.getFptrArray();
        ArrayList<DivType.Fptr> validFilesList = new ArrayList<DivType.Fptr>();
        for (DivType.Fptr file : files1) {
            if (localfilesToRemovePID.contains(file.getFILEID())) {
                localfilesToRemovePID.remove(file.getFILEID());
                continue;
            }
            validFilesList.add(file);
        }
        DivType.Fptr[] validFiles = new DivType.Fptr[validFilesList.size()];
        validFiles = validFilesList.toArray(validFiles);
        smDiv.setFptrArray(validFiles);
        if (localfilesToRemovePID.size() > 0) {
            divTypes = smDiv.getDivArray();
            for (int j = 0; j < divTypes.length; ++j) {
                this.removeFilesFromSM(divTypes[j], localfilesToRemovePID);
            }
        }
        return smDiv;
    }

    @Override
    public ArrayList<String> getFilesPidArrayFromSM(int index, String grpId) {
        ArrayList<String> fileList = new ArrayList<String>();
        DivType smDiv = this.getStructMapsByFileGrpId(grpId)[index].getDiv();
        List<DivType.Fptr> files = this.getFilesFromStructMap(smDiv);
        for (DivType.Fptr file : files) {
            fileList.add(file.getFILEID());
        }
        return fileList;
    }

    @Override
    public String getLabelOfFileFromSM(int index, String grpId, String pid) {
        DivType smDiv = this.getStructMapsByFileGrpId(grpId)[index].getDiv();
        return this.getLabelFromStructMap(smDiv, pid);
    }

    @Override
    public String getLabelFromStructMap(DivType smDiv, String pid) {
        String label = STRUCT_MAP_PREFIX;
        List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
        if (files1.size() == 1 && files1.get(0).getFILEID().equals(pid)) {
            label = smDiv.getLABEL();
            if (label == null || label.isEmpty()) {
                label = pid;
            }
            return label;
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length && (label = this.getLabelFromStructMap(divTypes[j], pid)).length() <= 0; ++j) {
        }
        return label;
    }

    @Override
    public void removeFileGrp(String grpId) throws IEParserException {
        this.removeFGSec(grpId);
        this.removeFGAmdSec(grpId);
        this.removeFGDmdSec(grpId);
        this.removeFGStructMaps(grpId);
    }
}

